/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import net.migueel26.faunaandorchestra.entity.custom.RedPandaEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RedPandaRandomChangeStanceGoal
extends Goal {
    private final int threshold = 500;
    private final RedPandaEntity redPanda;
    private final float probability;
    private int timeSpentInCurrentStance = 0;

    public RedPandaRandomChangeStanceGoal(RedPandaEntity redPanda, float probability) {
        this.redPanda = redPanda;
        this.probability = probability / 20.0f;
    }

    public boolean canUse() {
        ++this.timeSpentInCurrentStance;
        boolean flag = this.redPanda.getRandom().nextFloat() < this.probability * (float)this.timeSpentInCurrentStance / 200.0f && !this.redPanda.isInWater() && !this.redPanda.isHoldingInstrument() && this.redPanda.getNavigation().isDone() && this.timeSpentInCurrentStance > 500;
        return this.redPanda.isStanding() || flag;
    }

    public boolean canContinueToUse() {
        boolean flag;
        boolean bl = flag = this.timeSpentInCurrentStance < 500;
        if (!flag) {
            flag = this.redPanda.getRandom().nextFloat() > this.probability * (float)this.timeSpentInCurrentStance / 200.0f;
        }
        return flag && !this.redPanda.isInWater();
    }

    public void start() {
        this.redPanda.getNavigation().stop();
        if (!this.redPanda.isStanding()) {
            this.redPanda.standUp(true);
        }
        this.timeSpentInCurrentStance = 0;
    }

    public void stop() {
        this.redPanda.getNavigation().stop();
        if (!this.redPanda.isHoldingInstrument()) {
            this.redPanda.sitDownAnimated();
        }
        this.timeSpentInCurrentStance = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return super.requiresUpdateEveryTick();
    }

    public void tick() {
        ++this.timeSpentInCurrentStance;
    }
}

