/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.EnumSet;
import net.migueel26.faunaandorchestra.entity.custom.KoalaEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class TradeWithPlayerGoal
extends Goal {
    private final KoalaEntity mob;

    public TradeWithPlayerGoal(KoalaEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mob.isAlive()) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        if (this.mob.hurtMarked) {
            return false;
        }
        Player player = this.mob.getTradingPlayer();
        if (player == null) {
            return false;
        }
        return this.mob.distanceToSqr((Entity)player) > 16.0 ? false : player.containerMenu != null;
    }

    public void start() {
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.mob.setTradingPlayer(null);
    }
}

