/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.mixins.client;

import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.mixins.interfaces.ILevelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer
implements ILevelRenderer {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    ClientLevel level;

    @Shadow
    private void notifyNearbyEntities(Level level, BlockPos pos, boolean playing) {
    }

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    public void onLevelEvent(int type, BlockPos pos, int data, CallbackInfo ci) {
        if (type == 4005) {
            this.level.registryAccess().registryOrThrow(ModItems.ITEMS.getRegistryKey()).getHolder(data).ifPresent(item -> this.playOrchestraSong((Holder<Item>)item, pos));
        }
    }

    @Override
    public void playOrchestraSong(Holder<Item> itemHolder, BlockPos pos) {
        if (this.level != null) {
            Item item = (Item)itemHolder.value();
            this.minecraft.gui.setNowPlaying((Component)Component.translatable((String)("piece.faunaandorchestra." + MixinLevelRenderer.getName(item))));
            this.notifyNearbyEntities((Level)this.level, pos, true);
        }
    }

    @NotNull
    private static String getName(Item item) {
        String[] words = item.toString().split(":");
        return words[words.length - 1];
    }
}

