/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.networking;

import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.entity.TipCaseBlockEntity;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.migueel26.faunaandorchestra.entity.custom.TravellingMusician;
import net.migueel26.faunaandorchestra.entity.custom.boss.TheGreatComposer;
import net.migueel26.faunaandorchestra.mixins.client.accessors.ClientLevelAccessor;
import net.migueel26.faunaandorchestra.mixins.interfaces.ISoundManagerMixin;
import net.migueel26.faunaandorchestra.networking.RestartOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.ShowTitlePlayerS2CPayload;
import net.migueel26.faunaandorchestra.networking.StartAmbientMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StartOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.SyncTipCaseOwnerPayloadS2C;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.sound.custom.BossSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.FrogSongSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.InstrumentSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.TravellingMusicianSoundInstance;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    public static void handleEmpty(CustomPacketPayload payload, IPayloadContext iPayloadContext) {
    }

    public static void handleStartOrchestraOnNetwork(StartOrchestraMusicS2CPayload payload, IPayloadContext iPayloadContext) {
        iPayloadContext.enqueueWork(() -> {
            ClientLevelAccessor level = (ClientLevelAccessor)Minecraft.getInstance().level;
            UUID uuid = payload.entityID();
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(payload.soundPath());
            int ticksOffset = payload.tickOffset();
            if (level != null) {
                MusicalEntity entity = (MusicalEntity)level.callGetEntities().get(uuid);
                if (entity == null) {
                    System.err.println("The UUID in the StartOrchestraMusicPayload is for an entity that does not exist");
                }
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new InstrumentSoundInstance(entity, soundEvent, 1.0f, ticksOffset));
            }
        });
    }

    public static void handleRestartOrchestraOnNetwork(RestartOrchestraMusicS2CPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ConductorEntity conductor;
            List<UUID> UUIDorchestra = payload.orchestra();
            UUID conductorUUID = payload.conductor();
            float volume = payload.volume();
            int tickOffset = payload.tickOffset();
            ClientLevelAccessor level = (ClientLevelAccessor)Minecraft.getInstance().level;
            if (level != null && (conductor = (ConductorEntity)level.callGetEntities().get(conductorUUID)) != null) {
                Item newSheetMusic = MusicUtil.getSheet(payload.sheetName());
                if (newSheetMusic == Items.AIR) {
                    MusicUtil.deleteOrchestra(conductorUUID);
                    return;
                }
                conductor.setCurrentVolume(volume);
                boolean newSong = MusicUtil.updateNewSheet(conductorUUID, newSheetMusic);
                if (newSong) {
                    tickOffset = 0;
                }
                List<MusicalEntity> orchestra = UUIDorchestra.stream().map(uuid -> (MusicalEntity)level.callGetEntities().get(uuid)).toList();
                for (MusicalEntity musician : orchestra) {
                    ResourceLocation musician_song = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)MusicUtil.getLocation(newSheetMusic, (Item)musician.getInstrument().get()));
                    ((ISoundManagerMixin)Minecraft.getInstance().getSoundManager()).faunaStopMusic(musician.getUUID());
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)new InstrumentSoundInstance(musician, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(musician_song), volume, tickOffset));
                }
            }
        });
    }

    public static void handleStopMusicOnNetwork(StopMusicS2CPayload payload, IPayloadContext iPayloadContext) {
        UUID uuid = payload.entityUUID();
        ClientLevelAccessor level = (ClientLevelAccessor)Minecraft.getInstance().level;
        if (level != null) {
            Entity entity = (Entity)level.callGetEntities().get(uuid);
            if (entity instanceof QuirkyFrogEntity) {
                ((ISoundManagerMixin)Minecraft.getInstance().getSoundManager()).faunaStopFrogMusic(uuid);
            } else if (entity instanceof TravellingMusician) {
                ((ISoundManagerMixin)Minecraft.getInstance().getSoundManager()).faunaStopTravellingMusicianMusic(uuid);
            }
        }
    }

    public static void handleStartAmbientMusicOnNetwork(StartAmbientMusicS2CPayload payload, IPayloadContext iPayloadContext) {
        UUID uuid = payload.conductorUUID();
        ClientLevelAccessor level = (ClientLevelAccessor)Minecraft.getInstance().level;
        if (level != null) {
            Entity musician = (Entity)level.callGetEntities().get(uuid);
            if (musician instanceof QuirkyFrogEntity) {
                QuirkyFrogEntity quirkyFrog = (QuirkyFrogEntity)musician;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new FrogSongSoundInstance(ModSounds.FROG_SONG.get(), quirkyFrog));
            } else if (musician instanceof TravellingMusician) {
                TravellingMusician travellingMusician = (TravellingMusician)musician;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new TravellingMusicianSoundInstance(ModSounds.RINGTAILS_SONG.get(), travellingMusician));
            } else if (musician instanceof TheGreatComposer) {
                TheGreatComposer theGreatComposer = (TheGreatComposer)musician;
                SoundEvent soundEvent = theGreatComposer.isFinalPhase() ? ModSounds.THE_GREAT_COMPOSER_FINAL_THEME.get() : ModSounds.THE_GREAT_COMPOSER_THEME.get();
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new BossSoundInstance(soundEvent, (LivingEntity)theGreatComposer));
            } else {
                System.err.println("The UUID in the StartAmbientMusicPayload is for an entity that does not exist");
            }
        }
    }

    public static void handleStopOrchestraOnNetwork(StopOrchestraMusicS2CPayload payload, IPayloadContext iPayloadContext) {
        List<UUID> orchestraUUID = payload.orchestra();
        ClientLevelAccessor level = (ClientLevelAccessor)Minecraft.getInstance().level;
        if (level != null) {
            ISoundManagerMixin soundManager = (ISoundManagerMixin)Minecraft.getInstance().getSoundManager();
            for (UUID musicianUUID : orchestraUUID) {
                soundManager.faunaStopMusic(musicianUUID);
            }
        }
    }

    public static void handleShowTitleOnNetwork(ShowTitlePlayerS2CPayload payload, IPayloadContext context) {
        Gui gui = Minecraft.getInstance().gui;
        String title = payload.title();
        String subtitle = payload.subtitle();
        gui.setTitle((Component)Component.literal((String)title));
        gui.setSubtitle((Component)Component.literal((String)subtitle).withStyle(ChatFormatting.GREEN));
    }

    public static void handleSyncTipCaseOnNetwork(SyncTipCaseOwnerPayloadS2C payload, IPayloadContext context) {
        UUID uuid = payload.owner();
        BlockPos blockPos = new BlockPos(payload.x(), payload.y(), payload.z());
        ClientLevel level = Minecraft.getInstance().level;
        BlockState state = level.getBlockState(blockPos);
        Entity entity = (Entity)((ClientLevelAccessor)level).callGetEntities().get(uuid);
        if (state.getBlock() == ModBlocks.TIP_CASE.get() && entity != null) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            ((TipCaseBlockEntity)blockEntity).setOwner(uuid);
        }
    }
}

