/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.particles.custom;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class StarParticle
extends TextureSheetParticle {
    private final float rSpeed;

    protected StarParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 50;
        this.setSpriteFromAge(spriteSet);
        this.gravity = 0.5f;
        this.friction = 0.95f;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.oRoll = this.roll = level.random.nextFloat() * ((float)Math.PI * 2);
        this.rSpeed = (level.random.nextFloat() - 0.5f) * 0.6f;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += this.rSpeed;
        if (this.age >= 10) {
            this.alpha -= 0.05f;
        }
        if (this.alpha <= 0.0f) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            StarParticle star = new StarParticle(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
            star.pickSprite(this.spriteSet);
            return star;
        }
    }
}

