/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.networking.RestartOrchestraMusicC2SPayload;
import net.migueel26.faunaandorchestra.screen.ParticleButton;
import net.migueel26.faunaandorchestra.screen.custom.ConductorMenu;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConductorScreen
extends AbstractContainerScreen<ConductorMenu> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/conductor_gui.png");
    private final ConductorEntity conductor;
    private float xMouse;
    private float yMouse;
    private ExtendedSlider volumeSlider;
    private ParticleButton button;
    private boolean particlesActivated;
    private float volume;

    public ConductorScreen(ConductorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.conductor = menu.conductor;
        this.volume = 1.0f;
        this.particlesActivated = true;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.volumeSlider = new ExtendedSlider(x + 86, y + 57, 80, 13, (Component)Component.translatable((String)"screen.faunaandorchestra.conductor_screen"), (Component)Component.empty(), 0.0, 100.0, 100.0, true);
        this.volumeSlider.setValue((double)(this.conductor.getCurrentVolume() * 100.0f));
        this.button = new ParticleButton(x + 159, y + 5, (Component)Component.empty(), button -> this.conductor.activateParticles(!((ParticleButton)button).isPressed()));
        this.button.press(!this.conductor.areParticlesActivated());
        this.addRenderableWidget((GuiEventListener)this.volumeSlider);
        this.addRenderableWidget((GuiEventListener)this.button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (mouseX > (double)this.volumeSlider.getX() && mouseX < (double)(this.volumeSlider.getX() + 80) && mouseY > (double)this.volumeSlider.getY() && mouseY < (double)(this.volumeSlider.getY() + 13)) {
            this.volumeSlider.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Item currentSheetMusic;
        float currentVolume = (float)this.volumeSlider.getValue() / 100.0f;
        Item newSheetMusic = this.conductor.getSheetMusic();
        if (newSheetMusic != (currentSheetMusic = MusicUtil.getSheet(this.conductor.getUUID())) || currentVolume != this.volume) {
            this.volume = currentVolume;
            PacketDistributor.sendToServer((CustomPacketPayload)new RestartOrchestraMusicC2SPayload(this.conductor.getUUID(), this.volume), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void afterMouseAction() {
        super.afterMouseAction();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(x + 26), (int)(y + 22), (int)(x + 78), (int)(y + 70), (int)30, (float)0.25f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)this.conductor);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

