/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block;

import java.util.function.Supplier;
import net.migueel26.faunaandorchestra.block.custom.AltarBlock;
import net.migueel26.faunaandorchestra.block.custom.AltarOfTheButterfliesBlock;
import net.migueel26.faunaandorchestra.block.custom.AltarOfThePanFluteBlock;
import net.migueel26.faunaandorchestra.block.custom.ComposerGravestoneBlock;
import net.migueel26.faunaandorchestra.block.custom.CrawlingDiscordBlock;
import net.migueel26.faunaandorchestra.block.custom.DamBlock;
import net.migueel26.faunaandorchestra.block.custom.DiscordNucleiBlock;
import net.migueel26.faunaandorchestra.block.custom.DiscordedFlowerBlock;
import net.migueel26.faunaandorchestra.block.custom.FlowerGrowerDiscordBlock;
import net.migueel26.faunaandorchestra.block.custom.ListenerBlock;
import net.migueel26.faunaandorchestra.block.custom.ListenerContainerBlock;
import net.migueel26.faunaandorchestra.block.custom.MelomancyCauldronBlock;
import net.migueel26.faunaandorchestra.block.custom.RegularGravestoneBlock;
import net.migueel26.faunaandorchestra.block.custom.SingingCropBlock;
import net.migueel26.faunaandorchestra.block.custom.TheGreatHeadBlock;
import net.migueel26.faunaandorchestra.block.custom.TipCaseBlock;
import net.migueel26.faunaandorchestra.block.custom.VoiceChamberBlock;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.worldgen.tree.ModTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"faunaandorchestra");
    public static final DeferredBlock<Block> COMPOSER_GRAVESTONE = ModBlocks.registerBlock("composer_gravestone", () -> new ComposerGravestoneBlock(BlockBehaviour.Properties.of().noOcclusion().strength(-1.0f, 3600000.0f).noLootTable()));
    public static final DeferredBlock<Block> GRAVESTONE = ModBlocks.registerBlock("gravestone", () -> new RegularGravestoneBlock(BlockBehaviour.Properties.of().noOcclusion().strength(2.0f, 6.0f)));
    public static final DeferredBlock<Block> TIP_CASE = ModBlocks.registerBlock("tip_case", () -> new TipCaseBlock(BlockBehaviour.Properties.of().noOcclusion().strength(0.2f).ignitedByLava().pushReaction(PushReaction.DESTROY).sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> LISTENER = ModBlocks.registerBlock("listener", () -> new ListenerBlock(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> LISTENER_CONTAINER = ModBlocks.registerBlock("listener_container", () -> new ListenerContainerBlock(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> MELOMANCY_CAULDRON = ModBlocks.registerBlock("melomancy_cauldron", () -> new MelomancyCauldronBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).noOcclusion().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> ALTAR = ModBlocks.registerBlock("altar", () -> new AltarBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).noOcclusion().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> ALTAR_OF_THE_BUTTERFLIES = ModBlocks.registerBlock("altar_of_the_butterflies", () -> new AltarOfTheButterfliesBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).noOcclusion().sound(SoundType.STONE).randomTicks()));
    public static final DeferredBlock<Block> ALTAR_OF_THE_PAN_FLUTE = ModBlocks.registerBlock("altar_of_the_pan_flute", () -> new AltarOfThePanFluteBlock(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f).noOcclusion().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> VOICE_CHAMBER = ModBlocks.registerBlock("voice_chamber", () -> new VoiceChamberBlock(BlockBehaviour.Properties.of().noOcclusion().strength(1.0f, 6.0f)));
    public static final DeferredBlock<Block> CRAWLING_DISCORD = ModBlocks.registerBlock("crawling_discord", () -> new CrawlingDiscordBlock(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).sound(SoundType.SCULK)));
    public static final DeferredBlock<Block> FLOWER_DISCORD_BLOCK = ModBlocks.registerBlock("flower_discord_block", () -> new FlowerGrowerDiscordBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRAWLING_DISCORD.get()))));
    public static final DeferredBlock<Block> DISCORD_BLOCK = ModBlocks.registerBlock("discord_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CRAWLING_DISCORD.get()))){

        public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
            if (entity instanceof LivingEntity) {
                entity.hurt(level.damageSources().magic(), 2.0f);
            }
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX(), entity.getY(), entity.getZ(), 3, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.01f);
            }
            super.stepOn(level, pos, state, entity);
        }
    });
    public static final DeferredBlock<Block> DISCORDED_FLOWER = ModBlocks.registerBlock("discorded_flower", () -> new DiscordedFlowerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.SCULK_VEIN).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).randomTicks()));
    public static final DeferredBlock<Block> DISCORD_NUCLEI = ModBlocks.registerBlock("discord_nuclei", () -> new DiscordNucleiBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK_SHRIEKER)));
    public static final DeferredBlock<Block> DAM_BLOCK = ModBlocks.registerBlock("dam_block", () -> new DamBlock(BlockBehaviour.Properties.of().strength(0.7f).sound(SoundType.MANGROVE_ROOTS).noOcclusion().ignitedByLava()));
    public static final DeferredBlock<Block> SINGING_CROP = ModBlocks.registerBlock("singing_crop", () -> new SingingCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEETROOTS)));
    public static final DeferredBlock<Block> GINGKO_BILOBA_LEAVES = ModBlocks.registerBlock("gingko_biloba_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).ignitedByLava().pushReaction(PushReaction.DESTROY)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> GINGKO_BILOBA_SAPLING = ModBlocks.registerBlock("gingko_biloba_sapling", () -> new SaplingBlock(ModTreeGrowers.GINGKO_BILOBA_TREE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<Block> THE_GREAT_HEAD = ModBlocks.registerBlock("the_great_head", () -> new TheGreatHeadBlock(BlockBehaviour.Properties.of().strength(1.0f)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

