/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import com.mojang.serialization.MapCodec;
import net.migueel26.faunaandorchestra.block.entity.ComposerGravestoneBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerGravestoneBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<ComposerGravestoneBlock> CODEC = ComposerGravestoneBlock.simpleCodec(ComposerGravestoneBlock::new);
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OPENED = BlockStateProperties.OPEN;
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0, (double)15.0);

    public ComposerGravestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (ComposerGravestoneBlock.getConnectedDirection(state)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ComposerGravestoneBlockEntity(pos, state);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == ComposerGravestoneBlock.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            if (neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART)) {
                return (BlockState)state.setValue((Property)OPENED, (Comparable)((Boolean)neighborState.getValue((Property)OPENED)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            BlockPos blockPos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            level.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(blockpos1).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockpos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : null;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == BedPart.FOOT ? direction.getOpposite() : direction;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComposerGravestoneBlockEntity) {
            ComposerGravestoneBlockEntity composerGravestoneBlockEntity = (ComposerGravestoneBlockEntity)blockEntity;
            if (!((Boolean)state.getValue((Property)OPENED)).booleanValue()) {
                Vec3 center;
                Vec3 vecPos;
                BlockPos neighbourPos = pos.relative((Direction)state.getValue((Property)FACING));
                if (state.getValue(PART) == BedPart.HEAD) {
                    vecPos = neighbourPos.getBottomCenter();
                    composerGravestoneBlockEntity = (ComposerGravestoneBlockEntity)level.getBlockEntity(neighbourPos);
                } else {
                    vecPos = pos.getBottomCenter();
                }
                int diffX = neighbourPos.getX() - pos.getX();
                int diffZ = neighbourPos.getZ() - pos.getZ();
                double xOffset = 0.25;
                double zOffset = 0.25;
                if (diffX > 0) {
                    center = vecPos.subtract(0.5, 0.0, 0.0);
                    xOffset = 0.4;
                } else if (diffX < 0) {
                    center = vecPos.add(0.5, 0.0, 0.0);
                    xOffset = 0.4;
                } else if (diffZ > 0) {
                    center = vecPos.subtract(0.0, 0.0, 0.5);
                    zOffset = 0.4;
                } else {
                    center = vecPos.add(0.0, 0.0, 0.5);
                    zOffset = 0.4;
                }
                composerGravestoneBlockEntity.shake();
                player.displayClientMessage((Component)Component.translatable((String)"text.faunaandorchestra.locked_tomb"), true);
                player.playSound(SoundEvents.GRINDSTONE_USE, 1.0f, 0.5f);
                if (!level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.STONE.defaultBlockState()), center.x, center.y + 0.5, center.z, 20, xOffset, 0.0, zOffset, 1.0);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.HEAD ? direction : direction.getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OPENED});
    }
}

