/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.Iterator;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrawlingDiscordBlock
extends Block {
    public static int NEW_CHILD_TIME = 5;
    public static int DIE_TIME = 200;
    public static final int DEFAULT_MAX_GENERATION = 40;
    protected static int DIFFICULT_CHILD_TIME = 2;
    private boolean difficult = false;
    public static final IntegerProperty GENERATION = IntegerProperty.create((String)"generation", (int)0, (int)40);
    public static final BooleanProperty FATHER = BooleanProperty.create((String)"father");
    public static final BooleanProperty CLIMBER = BooleanProperty.create((String)"climber");
    public static final IntegerProperty MAX_GENERATION = IntegerProperty.create((String)"max_generation", (int)0, (int)40);
    private static final VoxelShape CRAWLER_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape CLIMBER_SHAPE = Shapes.block();

    public CrawlingDiscordBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GENERATION, (Comparable)Integer.valueOf(0))).setValue((Property)FATHER, (Comparable)Boolean.valueOf(false))).setValue((Property)CLIMBER, (Comparable)Boolean.valueOf(false))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(40)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)CLIMBER) != false ? CLIMBER_SHAPE : CRAWLER_SHAPE;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().magic(), 2.0f);
        }
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX(), entity.getY(), entity.getZ(), 3, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.01f);
        }
        super.stepOn(level, pos, state, entity);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().magic(), 2.0f);
        }
        if (!level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, entity.getX(), entity.getY(), entity.getZ(), 1, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.05f);
        }
        super.entityInside(state, level, pos, entity);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!oldState.is(ModBlocks.CRAWLING_DISCORD)) {
            level.scheduleTick(pos, (Block)this, this.getNewChildTime(level));
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean climber = (Boolean)state.getValue((Property)CLIMBER);
        if (!((Boolean)state.getValue((Property)FATHER)).booleanValue() && (Integer)state.getValue((Property)GENERATION) < (Integer)state.getValue((Property)MAX_GENERATION)) {
            int myGeneration = (Integer)state.getValue((Property)GENERATION);
            int maxGeneration = (Integer)state.getValue((Property)MAX_GENERATION);
            if (!climber) {
                boolean transformToClimber = false;
                Iterator iteratorUp = BlockPos.betweenClosed((BlockPos)pos.north().west(), (BlockPos)pos.south().east()).iterator();
                Iterator iteratorDown = BlockPos.betweenClosed((BlockPos)pos.below().north().west(), (BlockPos)pos.below().south().east()).iterator();
                int time = 0;
                while (iteratorUp.hasNext()) {
                    BlockPos nextPos = (BlockPos)iteratorUp.next();
                    BlockPos downPos = (BlockPos)iteratorDown.next();
                    if (time % 2 != 0) {
                        if (level.getBlockState(nextPos).is(ModTags.Blocks.REPLACEABLE_BY_DISCORD) && !level.getBlockState(nextPos.below()).isAir() && !level.getBlockState(nextPos.below()).is(ModBlocks.CRAWLING_DISCORD)) {
                            level.setBlock(nextPos, (BlockState)((BlockState)((Block)ModBlocks.CRAWLING_DISCORD.get()).defaultBlockState().setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration + 1))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                        }
                        if (level.getBlockState(downPos).is(ModTags.Blocks.REPLACEABLE_BY_DISCORD) && this.canGrab(downPos, level) && level.getBlockState(downPos.above()).isAir()) {
                            level.setBlock(downPos, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.CRAWLING_DISCORD.get()).defaultBlockState().setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration + 1))).setValue((Property)CLIMBER, (Comparable)Boolean.valueOf(true))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                        }
                    }
                    ++time;
                }
                if (this.canGrab(pos, level)) {
                    transformToClimber = true;
                }
                if (!transformToClimber) {
                    level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FATHER, (Comparable)Boolean.valueOf(true))).setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                    level.scheduleTick(pos, (Block)this, maxGeneration == 40 ? DIE_TIME : 100);
                } else {
                    level.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FATHER, (Comparable)Boolean.valueOf(false))).setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration))).setValue((Property)CLIMBER, (Comparable)Boolean.valueOf(true))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                    level.scheduleTick(pos, (Block)this, this.getNewChildTime((Level)level));
                }
            } else {
                Iterator iterator = BlockPos.betweenClosed((BlockPos)new BlockPos(pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1), (BlockPos)new BlockPos(pos.getX() - 1, pos.getY() - 1, pos.getZ() - 1)).iterator();
                int time = 0;
                while (iterator.hasNext()) {
                    BlockPos nextPos = (BlockPos)iterator.next();
                    if (time % 2 == 0 && level.getBlockState(nextPos).is(ModTags.Blocks.REPLACEABLE_BY_DISCORD) && this.canGrab(nextPos, level)) {
                        level.setBlock(nextPos, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.CRAWLING_DISCORD.get()).defaultBlockState().setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration + 1))).setValue((Property)CLIMBER, (Comparable)Boolean.valueOf(true))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                    }
                    ++time;
                }
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)FATHER, (Comparable)Boolean.valueOf(true))).setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration))).setValue((Property)CLIMBER, (Comparable)Boolean.valueOf(true)), 3);
                level.scheduleTick(pos, (Block)this, maxGeneration == 40 ? DIE_TIME : 100);
                if (level.getBlockState(pos.above()).is(ModTags.Blocks.REPLACEABLE_BY_DISCORD)) {
                    level.setBlock(pos.above(), (BlockState)((BlockState)((Block)ModBlocks.CRAWLING_DISCORD.get()).defaultBlockState().setValue((Property)GENERATION, (Comparable)Integer.valueOf(myGeneration + 1))).setValue((Property)MAX_GENERATION, (Comparable)Integer.valueOf(maxGeneration)), 3);
                }
            }
        } else {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    private boolean canGrab(BlockPos newPos, ServerLevel level) {
        return !level.getBlockState(newPos.east()).isAir() && !level.getBlockState(newPos.east()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.west()).isAir() && !level.getBlockState(newPos.west()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.north()).isAir() && !level.getBlockState(newPos.north()).is(ModBlocks.CRAWLING_DISCORD) || !level.getBlockState(newPos.south()).isAir() && !level.getBlockState(newPos.south()).is(ModBlocks.CRAWLING_DISCORD);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GENERATION, FATHER, CLIMBER, MAX_GENERATION});
    }

    private int getNewChildTime(Level level) {
        return this.difficult ? level.random.nextInt(DIFFICULT_CHILD_TIME, DIFFICULT_CHILD_TIME + 7) : level.random.nextInt(NEW_CHILD_TIME, NEW_CHILD_TIME + 10);
    }

    public void setDifficult(boolean difficult) {
        this.difficult = difficult;
    }
}

