/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.List;
import java.util.Optional;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.ListenerBlock;
import net.migueel26.faunaandorchestra.block.entity.ListenerContainerBlockEntity;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ListenerContainerBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty LISTENING = BooleanProperty.create((String)"listening");
    public static final BooleanProperty BOTTLE = BooleanProperty.create((String)"bottle");
    public static final IntegerProperty DROPLETS = IntegerProperty.create((String)"droplets", (int)0, (int)64);
    public static final VoxelShape BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CORNER_SW = Block.box((double)14.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    public static final VoxelShape CORNER_SE = Block.box((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
    public static final VoxelShape CORNER_NW = Block.box((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape CORNER_NE = Block.box((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{TOP, CORNER_SW, CORNER_NE, CORNER_SE, CORNER_NW});
    public static final int NEXT_TICK_SCHEDULED = 20;
    int seconds;

    public ListenerContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LISTENING, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTLE, (Comparable)Boolean.valueOf(false))).setValue((Property)DROPLETS, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"block.faunaandorchestra.listener_container.desc").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.is(ModBlocks.LISTENER_CONTAINER) && level.getBlockState(pos.above()).is(ModBlocks.LISTENER) && !level.isClientSide()) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, pos.getCenter().x, (double)pos.getY() + 0.5, pos.getCenter().z, 25, 0.1, 0.5, 0.1, 0.2);
            level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 2.0f);
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!newState.is(ModBlocks.LISTENER_CONTAINER) && ((Boolean)state.getValue((Property)BOTTLE)).booleanValue()) {
            if ((Integer)state.getValue((Property)DROPLETS) == 64) {
                ListenerContainerBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.MUSIC_BOTTLE.get()));
            } else {
                ListenerContainerBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            if (level.getBlockState(pos.above()).is(ModBlocks.LISTENER)) {
                level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue((Property)ListenerBlock.LISTENING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int drops = (Integer)state.getValue((Property)DROPLETS);
        Optional<ConductorEntity> conductor = level.getEntitiesOfClass(ConductorEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)10.0, (double)10.0, (double)10.0)).stream().filter(ConductorEntity::isConducting).filter(ConductorEntity::isOrchestraFull).findAny();
        if (conductor.isPresent()) {
            ListenerContainerBlock.updateListeningAssembledListener(level, pos, state, true);
            if (drops < 64 && ((Boolean)state.getValue((Property)BOTTLE)).booleanValue()) {
                level.sendParticles((ParticleOptions)ModParticleTypes.DRIPPING_MUSIC.get(), pos.getCenter().x, (double)pos.getY() + 0.75, pos.getCenter().z, 3, 0.0, 0.0, 0.0, 0.1);
            }
        } else {
            ListenerContainerBlock.updateListeningAssembledListener(level, pos, state, false);
        }
        if (this.seconds % 5 == 0 && ((Boolean)state.getValue((Property)LISTENING)).booleanValue() && drops < 64 && ((Boolean)state.getValue((Property)BOTTLE)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)DROPLETS, (Comparable)Integer.valueOf(drops + 1)), 3);
        }
        ++this.seconds;
        this.checkIfStillAssembled(level, pos, state);
        super.tick(state, level, pos, random);
    }

    private static void updateListeningAssembledListener(ServerLevel level, BlockPos pos, BlockState state, boolean listening) {
        if (level.getBlockState(pos.above()).is(ModBlocks.LISTENER)) {
            level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue((Property)ListenerBlock.LISTENING, (Comparable)Boolean.valueOf(listening)), 3);
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)LISTENING, (Comparable)Boolean.valueOf(listening)), 3);
    }

    private void checkIfStillAssembled(ServerLevel level, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos.above()).is(ModBlocks.LISTENER) && ((Boolean)state.getValue((Property)BOTTLE)).booleanValue()) {
            level.scheduleTick(pos, (Block)this, 20);
        } else {
            this.seconds = 0;
            ListenerContainerBlock.updateListeningAssembledListener(level, pos, state, false);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack item = player.getItemInHand(hand);
        if (item.is(Items.GLASS_BOTTLE)) {
            if (this.isFull(state)) {
                item.consume(1, (LivingEntity)player);
                player.addItem(new ItemStack((ItemLike)ModItems.MUSIC_BOTTLE.get(), 1));
                level.setBlock(pos, (BlockState)state.setValue((Property)DROPLETS, (Comparable)Integer.valueOf(0)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (this.isContainerEmpty(state)) {
                item.consume(1, (LivingEntity)player);
                level.setBlock(pos, (BlockState)state.setValue((Property)BOTTLE, (Comparable)Boolean.valueOf(true)), 3);
                level.scheduleTick(pos, (Block)this, 20);
                return ItemInteractionResult.SUCCESS;
            }
        } else if ((item.isEmpty() || item.is(ModItems.MUSIC_BOTTLE)) && this.isFull(state)) {
            player.addItem(new ItemStack((ItemLike)ModItems.MUSIC_BOTTLE.get(), 1));
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DROPLETS, (Comparable)Integer.valueOf(0))).setValue((Property)BOTTLE, (Comparable)Boolean.valueOf(false)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ListenerContainerBlockEntity(pos, state);
    }

    private boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)DROPLETS) == 64 && (Boolean)state.getValue((Property)BOTTLE) != false;
    }

    private boolean isContainerEmpty(BlockState state) {
        return (Boolean)state.getValue((Property)BOTTLE) == false;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LISTENING, BOTTLE, DROPLETS});
    }
}

