/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import net.migueel26.faunaandorchestra.block.entity.VoiceChamberBlockEntity;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.util.VesselUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VoiceChamberBlock
extends Block
implements EntityBlock {
    public static BooleanProperty VOICE = BooleanProperty.create((String)"voice");
    public static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)0.75, (double)10.0);

    public VoiceChamberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)VOICE, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        VoiceChamberBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof VoiceChamberBlockEntity && !(blockEntity = (VoiceChamberBlockEntity)blockEntity2).isLocked()) {
            if (stack.is(ModItems.VOICE) && stack.has(ModDataComponents.FAUNA_NAME) && !((Boolean)state.getValue((Property)VOICE)).booleanValue()) {
                String voice = (String)stack.get(ModDataComponents.FAUNA_NAME);
                EntityType entityType = (EntityType)EntityType.byString((String)voice).orElseThrow();
                Entity entity = entityType.create(level);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f);
                    level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SCULK_BLOCK_HIT, SoundSource.BLOCKS, 1.0f, 1.5f);
                    mob.playAmbientSound();
                    mob.discard();
                }
                if (!level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ModParticleTypes.MAGICAL_NOTE.get(), pos.getCenter().x, (double)((float)pos.getY() + 0.5f), pos.getCenter().z, 20, 0.1, 0.1, 0.1, 0.05);
                }
                blockEntity.setVoice(voice);
                stack.consume(1, (LivingEntity)player);
                level.setBlock(pos, (BlockState)state.setValue((Property)VOICE, (Comparable)Boolean.valueOf(true)), 3);
                return ItemInteractionResult.SUCCESS;
            }
            if (stack.isEmpty() && ((Boolean)state.getValue((Property)VOICE)).booleanValue()) {
                EntityType entityType = (EntityType)EntityType.byString((String)blockEntity.getVoice()).orElseThrow();
                Entity entity = entityType.create(level);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f);
                    level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SCULK_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.5f);
                    mob.playAmbientSound();
                    mob.discard();
                }
                if (!level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, pos.getCenter().x, (double)((float)pos.getY() + 0.5f), pos.getCenter().z, 10, 0.1, 0.1, 0.1, 0.03);
                }
                player.setItemInHand(hand, VesselUtil.voiceOfEntity((EntityType<? extends Entity>)entityType));
                blockEntity.setVoice("");
                level.setBlock(pos, (BlockState)state.setValue((Property)VOICE, (Comparable)Boolean.valueOf(false)), 3);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VoiceChamberBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VOICE});
    }
}

