/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.LemurEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class LemurModel
extends GeoModel<LemurEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/lemur.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/lemur.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/lemur.geo.json");

    public ResourceLocation getModelResource(LemurEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(LemurEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(LemurEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(LemurEntity lemur, long instanceId, AnimationState<LemurEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !lemur.isPlayingInstrument()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        GeoBone oboe = this.getAnimationProcessor().getBone("oboe");
        GeoBone secondary_oboe = this.getAnimationProcessor().getBone("secondary_oboe");
        oboe.setHidden(!lemur.isHoldingInstrument());
        secondary_oboe.setHidden(!animationState.isCurrentAnimation(LemurEntity.WALK_OBOE));
    }
}

