/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.MantisEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class MantisModel
extends GeoModel<MantisEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/mantis.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/mantis.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/mantis.geo.json");

    public ResourceLocation getModelResource(MantisEntity mantis) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(MantisEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(MantisEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(MantisEntity mantis, long instanceId, AnimationState<MantisEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !mantis.isPlayingInstrument()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        GeoBone left_pupil = this.getAnimationProcessor().getBone("left_pupil");
        GeoBone right_pupil = this.getAnimationProcessor().getBone("right_pupil");
        GeoBone violin = this.getAnimationProcessor().getBone("violin");
        GeoBone bow = this.getAnimationProcessor().getBone("bow");
        if (mantis.isAngry()) {
            left_pupil.setHidden(true);
            right_pupil.setHidden(true);
        } else {
            left_pupil.setHidden(false);
            right_pupil.setHidden(false);
        }
        if (mantis.isHoldingInstrument()) {
            violin.setHidden(false);
            bow.setHidden(false);
        } else {
            violin.setHidden(true);
            bow.setHidden(true);
        }
    }
}

