/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.goals.BeaverBuildsDamGoal;
import net.migueel26.faunaandorchestra.entity.goals.FaunaRandomLookAroundGoal;
import net.migueel26.faunaandorchestra.entity.goals.MusicalEntityPlayingInstrumentGoal;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BeaverEntity
extends MusicalEntity
implements GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_SAXOPHONE = RawAnimation.begin().thenPlay("holding_sax");
    protected static final RawAnimation WALKING = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation SWIMMING = RawAnimation.begin().thenPlay("swim");
    protected static final RawAnimation WALKING_SAXOPHONE = RawAnimation.begin().thenPlay("walk_sax");
    protected static final RawAnimation PLAYING = RawAnimation.begin().thenPlay("playing");
    protected static final RawAnimation BUILD = RawAnimation.begin().thenPlay("build");
    protected static final EntityDataAccessor<Boolean> BUILDING = SynchedEntityData.defineId(BeaverEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimationController<BeaverEntity> beaverController = new AnimationController((GeoAnimatable)this, "beaver_controller", 5, this::beaverState).triggerableAnim("build_trigger", BUILD);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int bubbleTick = 0;
    Vec3 lastPosition = this.position();

    public BeaverEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.addOverridenGoals();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BUILDING, (Object)false);
    }

    @Override
    public DeferredItem<Item> getInstrument() {
        return ModItems.SAXOPHONE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 2.0));
        this.goalSelector.addGoal(1, (Goal)new MusicalEntityPlayingInstrumentGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new BeaverBuildsDamGoal(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new FaunaRandomLookAroundGoal((Mob)this));
    }

    protected void addOverridenGoals() {
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                return super.canUse() && !((MusicalEntity)this.mob).isPlayingInstrument() && !((BeaverEntity)this.mob).isBuilding();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !((MusicalEntity)this.mob).isPlayingInstrument() && !((BeaverEntity)this.mob).isBuilding();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal(this, (PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && !((BeaverEntity)this.mob).isBuilding();
            }
        });
    }

    private <E extends GeoAnimatable> PlayState beaverState(AnimationState<E> state) {
        if (this.isPlayingInstrument()) {
            state.getController().setAnimation(PLAYING);
        } else if (state.isMoving() && !this.isInWater()) {
            state.getController().setAnimation(this.isHoldingInstrument() ? WALKING_SAXOPHONE : WALKING);
        } else if (state.isMoving() && this.isInWater()) {
            state.getController().setAnimation(SWIMMING);
        } else if (this.isHoldingInstrument()) {
            state.getController().setAnimation(IDLE_SAXOPHONE);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.AXOLOTL_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    public void aiStep() {
        if (this.level().isClientSide() && this.isInWater() && this.bubbleTick >= 10 && (this.lastPosition.x != this.getX() || this.lastPosition.z != this.getZ())) {
            this.doWaterSplashEffect();
            this.bubbleTick = 0;
        } else {
            ++this.bubbleTick;
        }
        this.lastPosition = this.position();
        super.aiStep();
    }

    public void build() {
        this.setBuilding(true);
        this.triggerAnim("beaver_controller", "build_trigger");
    }

    public boolean isBuilding() {
        return (Boolean)this.entityData.get(BUILDING);
    }

    public void setBuilding(boolean building) {
        this.entityData.set(BUILDING, (Object)building);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.beaverController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

