/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.ArrayList;
import java.util.List;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.Orion;
import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.migueel26.faunaandorchestra.entity.custom.TravellingMusician;
import net.migueel26.faunaandorchestra.entity.goals.FaustFindOrionGoal;
import net.migueel26.faunaandorchestra.entity.goals.RingtailsRunAwayGoal;
import net.migueel26.faunaandorchestra.networking.StartAmbientMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopMusicS2CPayload;
import net.migueel26.faunaandorchestra.util.ModSavedData;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Faust
extends TravellingMusician
implements Npc,
GeoEntity,
TalkableEntity {
    private static final RawAnimation PLAYING = RawAnimation.begin().thenPlay("playing");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final EntityDataAccessor<Integer> DIALOGUE_TIMER = SynchedEntityData.defineId(Faust.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> CONFIDENCE = SynchedEntityData.defineId(Faust.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> GOOD_MORNING = SynchedEntityData.defineId(Faust.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/faust_icon.png");
    public static final int COOL_CONFIDENCE = 35;
    public static final int DEFAULT_LOOK_TIME = 60;
    public static final String RESOURCE = "dialogue.faunaandorchestra.faust";
    public String currentDialogue;
    private List<Player> playersListening = new ArrayList<Player>();
    protected Orion orion;
    protected BlockPos tipCasePos;
    private int lookTime;
    protected int confidence;
    private final AnimationController<Faust> faustController = new AnimationController((GeoAnimatable)this, "faust_controller", 5, this::faustState);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Faust(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.setCustomName((Component)Component.translatable((String)"entity.faunaandorchestra.faust"));
        this.tipCasePos = null;
        this.lookTime = 60;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIALOGUE_TIMER, (Object)0);
        builder.define(CONFIDENCE, (Object)0);
        builder.define(GOOD_MORNING, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RingtailsRunAwayGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(1, (Goal)new FaustFindOrionGoal(this));
    }

    private <E extends GeoAnimatable> PlayState faustState(AnimationState<E> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(WALK);
        } else if (this.isPlaying()) {
            state.getController().setAnimation(PLAYING);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getDialogueTimer() == 0) {
            if (this.level().isClientSide()) {
                this.increaseDialogueTimer();
            } else {
                this.confidence = ModSavedData.getConfidence((ServerLevel)this.level(), this, player.getUUID());
                this.setConfidence(this.confidence);
                if (this.confidence >= 35) {
                    ((CustomSimpleTrigger)((Object)ModAdvancements.BEFRIEND_FAUST.get())).trigger((ServerPlayer)player);
                }
                ModSavedData.saveConfidence((ServerLevel)this.level(), this, player.getUUID(), this.confidence + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        BlockPos pos = new BlockPos(compound.getInt("X"), compound.getInt("Y"), compound.getInt("Z"));
        if (pos.getX() != 0 || pos.getY() != 0 || pos.getZ() != 0) {
            this.tipCasePos = pos;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.tipCasePos != null) {
            compound.putInt("X", this.tipCasePos.getX());
            compound.putInt("Y", this.tipCasePos.getY());
            compound.putInt("Z", this.tipCasePos.getZ());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected void tickDeath() {
        if (this.orion != null) {
            this.orion.setFaust(null);
        }
        super.tickDeath();
    }

    public void tick() {
        if (this.isPlaying() && !this.level().isClientSide()) {
            List nearbyPlayers = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(32.0, 32.0, 32.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE);
            ArrayList newPlayers = new ArrayList(nearbyPlayers);
            ArrayList<Player> exitPlayers = new ArrayList<Player>(this.playersListening);
            exitPlayers.removeAll(nearbyPlayers);
            newPlayers.removeAll(this.playersListening);
            for (Player player : newPlayers) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StartAmbientMusicS2CPayload(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((CustomSimpleTrigger)((Object)ModAdvancements.MEET_RINGTAILS.get())).trigger((ServerPlayer)player);
            }
            for (Player player : exitPlayers) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StopMusicS2CPayload(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.playersListening = nearbyPlayers;
        } else {
            this.playersListening = new ArrayList<Player>();
        }
        if (this.tipCasePos != null && this.orion != null) {
            if (this.lookTime > 0) {
                --this.lookTime;
            } else {
                Vec3 vec3 = new Vec3((double)this.tipCasePos.getX(), (double)this.tipCasePos.getY(), (double)this.tipCasePos.getZ());
                this.lookAt(EntityAnchorArgument.Anchor.FEET, vec3);
                this.orion.lookAt(EntityAnchorArgument.Anchor.FEET, vec3);
                this.lookTime = 60;
            }
        }
        super.tick();
    }

    public void checkDespawn() {
    }

    public boolean canBeLeashed() {
        return false;
    }

    @Override
    public void setPlaying(boolean playing) {
        super.setPlaying(playing);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.faustController);
    }

    public void setOrion(Orion orion) {
        this.orion = orion;
    }

    public Orion getOrion() {
        return this.orion;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public String getRandomDialogue(Player player) {
        Object dialogue = this.currentDialogue;
        boolean goodMorning = (Boolean)this.entityData.get(GOOD_MORNING);
        this.confidence = this.getConfidence();
        if (this.getDialogueTimer() <= 5) {
            if (this.confidence == -1) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.faust2").getString();
                String[] arr = ((String)dialogue).split("%");
                dialogue = arr[0] + player.getDisplayName().getString() + arr[1];
            } else if (this.confidence == 0 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.faust0").getString();
            } else if (this.confidence > 0 && this.confidence <= 35 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.faust1").getString();
                String[] arr = ((String)dialogue).split("%");
                dialogue = arr[0] + player.getDisplayName().getString() + arr[1];
            } else if (this.confidence > 35 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.faust1s").getString();
            } else {
                int randomDialogue = this.random.nextInt(3, 20);
                dialogue = Component.translatable((String)(RESOURCE + randomDialogue)).getString();
                if (randomDialogue >= 16 && this.confidence > 35) {
                    dialogue = Component.translatable((String)(RESOURCE + randomDialogue + "s")).getString();
                }
            }
            this.currentDialogue = dialogue;
        }
        return dialogue;
    }

    @Override
    public Pair<Integer, Integer> getIconSize() {
        return new Pair((Object)49, (Object)60);
    }

    @Override
    public Pair<Integer, Integer> getIconLocation() {
        return new Pair((Object)107, (Object)136);
    }

    @Override
    public int getDialogueTimer() {
        return (Integer)this.entityData.get(DIALOGUE_TIMER);
    }

    @Override
    public void increaseDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)(this.getDialogueTimer() + 1));
    }

    @Override
    public void resetDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)0);
    }

    @Override
    public void setGoodMorning(boolean goodMorning) {
        this.entityData.set(GOOD_MORNING, (Object)goodMorning);
    }

    @Override
    public boolean getGoodMorning() {
        return (Boolean)this.entityData.get(GOOD_MORNING);
    }

    public void setConfidence(int confidence) {
        this.entityData.set(CONFIDENCE, (Object)confidence);
    }

    public int getConfidence() {
        return (Integer)this.entityData.get(CONFIDENCE);
    }

    public BlockPos getTipCasePos() {
        return this.tipCasePos;
    }

    public void setTipCasePos(BlockPos pos) {
        this.tipCasePos = pos;
    }
}

