/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.migueel26.faunaandorchestra.entity.custom.TravellingMusician;
import net.migueel26.faunaandorchestra.entity.goals.RingtailsRunAwayGoal;
import net.migueel26.faunaandorchestra.util.ModSavedData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Orion
extends TravellingMusician
implements Npc,
GeoEntity,
TalkableEntity {
    private static final RawAnimation PLAYING = RawAnimation.begin().thenPlay("playing");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final EntityDataAccessor<Integer> DIALOGUE_TIMER = SynchedEntityData.defineId(Orion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> CONFIDENCE = SynchedEntityData.defineId(Orion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> GOOD_MORNING = SynchedEntityData.defineId(Orion.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/orion_icon.png");
    public static final int COOL_CONFIDENCE = 35;
    public static final String RESOURCE = "dialogue.faunaandorchestra.orion";
    public String currentDialogue;
    protected Faust faust;
    private final AnimationController<Orion> orionController = new AnimationController((GeoAnimatable)this, "orion_controller", 5, this::orionState);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int confidence;

    public Orion(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.setCustomName((Component)Component.translatable((String)"entity.faunaandorchestra.orion"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIALOGUE_TIMER, (Object)0);
        builder.define(CONFIDENCE, (Object)0);
        builder.define(GOOD_MORNING, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RingtailsRunAwayGoal((PathfinderMob)this, 2.0));
    }

    private <E extends GeoAnimatable> PlayState orionState(AnimationState<E> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(WALK);
        } else if (this.isPlaying()) {
            state.getController().setAnimation(PLAYING);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public void checkDespawn() {
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getDialogueTimer() == 0) {
            if (this.level().isClientSide()) {
                this.increaseDialogueTimer();
            } else {
                this.confidence = ModSavedData.getConfidence((ServerLevel)this.level(), this, player.getUUID());
                this.setConfidence(this.confidence);
                if (this.confidence >= 35) {
                    ((CustomSimpleTrigger)((Object)ModAdvancements.BEFRIEND_ORION.get())).trigger((ServerPlayer)player);
                }
                ModSavedData.saveConfidence((ServerLevel)this.level(), this, player.getUUID(), this.confidence + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.orionController);
    }

    public void setFaust(Faust faust) {
        this.faust = faust;
    }

    public Faust getFaust() {
        return this.faust;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public String getRandomDialogue(Player player) {
        Object dialogue = this.currentDialogue;
        boolean goodMorning = (Boolean)this.entityData.get(GOOD_MORNING);
        this.confidence = this.getConfidence();
        if (this.getDialogueTimer() <= 5) {
            if (this.confidence == -1) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.orion2").getString();
                String[] arr = ((String)dialogue).split("%");
                dialogue = arr[0] + player.getDisplayName().getString() + arr[1];
            } else if (this.confidence == 0 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.orion0").getString();
            } else if (this.confidence > 0 && this.confidence <= 35 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.orion1").getString();
            } else if (this.confidence > 35 && goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.orion1s").getString();
                String[] arr = ((String)dialogue).split("%");
                dialogue = arr[0] + player.getDisplayName().getString() + arr[1];
            } else {
                int randomDialogue = this.random.nextInt(3, 20);
                dialogue = Component.translatable((String)(RESOURCE + randomDialogue)).getString();
                if (randomDialogue >= 16 && this.confidence > 35) {
                    dialogue = Component.translatable((String)(RESOURCE + randomDialogue + "s")).getString();
                }
            }
            this.currentDialogue = dialogue;
        }
        return dialogue;
    }

    public boolean canBeLeashed() {
        return false;
    }

    @Override
    public Pair<Integer, Integer> getIconSize() {
        return new Pair((Object)49, (Object)60);
    }

    @Override
    public Pair<Integer, Integer> getIconLocation() {
        return new Pair((Object)107, (Object)136);
    }

    @Override
    public int getDialogueTimer() {
        return (Integer)this.entityData.get(DIALOGUE_TIMER);
    }

    @Override
    public void increaseDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)(this.getDialogueTimer() + 1));
    }

    @Override
    public void resetDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)0);
    }

    @Override
    public void setGoodMorning(boolean goodMorning) {
        this.entityData.set(GOOD_MORNING, (Object)goodMorning);
    }

    @Override
    public boolean getGoodMorning() {
        return (Boolean)this.entityData.get(GOOD_MORNING);
    }

    public void setConfidence(int confidence) {
        this.entityData.set(CONFIDENCE, (Object)confidence);
    }

    public int getConfidence() {
        return (Integer)this.entityData.get(CONFIDENCE);
    }
}

