/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.Optional;
import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.AbstractCanonEntity;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlayerCanonEntity
extends AbstractCanonEntity {
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    protected static final EntityDataAccessor<Optional<UUID>> CONDUCTOR_UUID = SynchedEntityData.defineId(PlayerCanonEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected UUID conductorUUID;
    protected int scheduleDeath = -1;
    private final AnimationController<PlayerCanonEntity> canonController = new AnimationController((GeoAnimatable)this, "player_canon_controller", 5, this::canonState).triggerableAnim("attack", ATTACK);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PlayerCanonEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, true){

            protected void checkAndPerformAttack(LivingEntity target) {
                if (this.canPerformAttack(target)) {
                    this.resetAttackCooldown();
                    this.mob.swing(InteractionHand.MAIN_HAND);
                    this.mob.doHurtTarget((Entity)target);
                    ((PlayerCanonEntity)this.mob).triggerAnim("player_canon_controller", "attack");
                }
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    private <E extends GeoAnimatable> PlayState canonState(AnimationState<E> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(WALK);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult interactionresult = super.mobInteract(player, hand);
        if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)player)) {
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return interactionresult;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CONDUCTOR_UUID, Optional.empty());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(CONDUCTOR_UUID)) {
            this.conductorUUID = ((Optional)this.entityData.get(CONDUCTOR_UUID)).orElse(null);
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putUUID("ConductorUUID", this.conductorUUID);
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("ConductorUUID")) {
            this.entityData.set(CONDUCTOR_UUID, Optional.of(compound.getUUID("ConductorUUID")));
        }
        super.readAdditionalSaveData(compound);
    }

    public void tick() {
        ConductorEntity conductor;
        Entity entity;
        if (this.level().isClientSide() && this.skin == null && this.getOwner() != null) {
            this.setSkin(((AbstractClientPlayer)this.getOwner()).getSkin());
            this.setCustomName(this.getOwner() == null ? this.getName() : this.getOwner().getDisplayName());
        }
        if (this.tickCount % 20 == 0 && this.scheduleDeath == -1 && !this.level().isClientSide() && (entity = ((ServerLevel)this.level()).getEntity(this.conductorUUID)) instanceof ConductorEntity && ((conductor = (ConductorEntity)entity).isAlive() && !conductor.isConducting() || conductor.isDeadOrDying())) {
            this.scheduleDeath = 3;
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.position().x, this.blockPosition().getCenter().y, this.position().z, 30, 0.1, 0.1, 0.1, 0.2);
        }
        if (this.scheduleDeath == 0) {
            this.discard();
        } else if (this.scheduleDeath > 0) {
            --this.scheduleDeath;
        }
        super.tick();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 7.0);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.PLAYER_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public void setConductor(ConductorEntity conductor) {
        this.conductorUUID = conductor.getUUID();
    }

    public UUID getConductorUUID() {
        return this.conductorUUID;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.canonController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

