/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.goals.FaunaRandomLookAroundGoal;
import net.migueel26.faunaandorchestra.entity.goals.SingingSproutlingGatherGoal;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SproutlingEntity
extends AgeableMob
implements GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SING = RawAnimation.begin().thenPlay("sing");
    protected static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    protected static final EntityDataAccessor<Boolean> SINGING = SynchedEntityData.defineId(SproutlingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected List<SproutlingEntity> sproutlings = null;
    protected Vec3 centroid = null;
    protected UUID ownerUUID = null;
    public static final int TICKS_UNTIL_SING = 400;
    public static final int MAX_TICKS_SINGING = 42;
    private final AnimationController<SproutlingEntity> sproutlingController = new AnimationController((GeoAnimatable)this, "sproutling_controller", 5, this::sproutlingState).triggerableAnim("sing_trigger", SING);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean isSinging;
    protected int ticksUntilSing = 400;
    protected int ticksSinging = -1;
    protected int ticks = 0;

    public SproutlingEntity(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.addOverridenGoals();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SINGING, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(SINGING)) {
            this.isSinging = (Boolean)this.entityData.get(SINGING);
        }
        super.onSyncedDataUpdated(key);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SingingSproutlingGatherGoal(this));
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(3, (Goal)new FaunaRandomLookAroundGoal((Mob)this));
    }

    private void addOverridenGoals() {
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal(this, (PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && !((SproutlingEntity)this.mob).isSinging();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 8.0f){

            public boolean canUse() {
                return super.canUse() && !((SproutlingEntity)this.mob).isSinging();
            }
        });
    }

    private <E extends GeoAnimatable> PlayState sproutlingState(AnimationState<E> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(WALK);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.sproutlingController);
    }

    public boolean isSinging() {
        return this.isSinging;
    }

    public void setSinging(boolean singing) {
        this.entityData.set(SINGING, (Object)singing);
        this.isSinging = singing;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.RABBIT_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    public void tick() {
        if (this.ticks % 11 == 0 && !this.isPathFinding()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GRASS_HIT, SoundSource.AMBIENT, 0.5f, 1.0f);
        } else if (this.isPathFinding()) {
            this.ticks = 0;
        }
        if (this.ticksUntilSing > 0) {
            --this.ticksUntilSing;
        } else if (!this.isSinging() && this.navigation.isDone()) {
            this.setSinging(true);
            this.triggerAnim("sproutling_controller", "sing_trigger");
            this.ticksSinging = 0;
        }
        if (this.ticksSinging == 14 && !this.level().isClientSide) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY() + 1.0, this.getZ(), 1, 0.0, 0.0, 0.0, 1.0);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.SINGING_SPROUTLING_SOUND.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        if (this.ticksSinging >= 0 && this.ticksSinging < 42) {
            ++this.ticksSinging;
        } else if (this.isSinging()) {
            if (!this.level().isClientSide()) {
                BlockState state = this.level().getBlockState(this.blockPosition().below());
                Block block = state.getBlock();
                if (block instanceof BonemealableBlock) {
                    BonemealableBlock block2 = (BonemealableBlock)block;
                    block2.performBonemeal((ServerLevel)this.level(), this.random, this.blockPosition().below(), state);
                }
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.MAGIC_GROWTH.get(), SoundSource.NEUTRAL);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY(), this.getZ(), 60, 1.5, 1.0, 5.0, 0.3);
            }
            this.setSinging(false);
            this.ticksUntilSing = 400;
            this.ticksSinging = -1;
        }
        ++this.ticks;
        super.tick();
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public Vec3 getDirCentroid() {
        return this.centroid;
    }

    public List<SproutlingEntity> getDirSproutlings() {
        return this.sproutlings;
    }

    public void setDirSproutlings(List<SproutlingEntity> sproutlings) {
        this.sproutlings = sproutlings;
    }

    public void setDirCentroid(Vec3 centroid) {
        this.centroid = centroid;
    }

    public UUID getDirOwnerUUID() {
        return this.ownerUUID;
    }

    public void setDirOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public List<SproutlingEntity> getDirSproutlingsMinusDir() {
        this.sproutlings.remove((Object)this);
        return this.sproutlings;
    }
}

