/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import javax.annotation.Nullable;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WanderingNoteEntity
extends AmbientCreature {
    public int scheduleDeath = -1;
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.defineId(WanderingNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.defineId(WanderingNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private BlockPos targetPosition;

    public WanderingNoteEntity(EntityType<? extends AmbientCreature> p_27403_, Level p_27404_) {
        super(p_27403_, p_27404_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE_INDEX, (Object)this.random.nextInt(8));
        builder.define(LIFETIME, (Object)0);
    }

    public void tick() {
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        this.increaseLifetime();
        if (this.getLifetime() == 255 || this.scheduleDeath == 0) {
            this.discard();
        }
        if (this.scheduleDeath > 0) {
            --this.scheduleDeath;
        }
        super.tick();
    }

    private void increaseLifetime() {
        this.entityData.set(LIFETIME, (Object)(this.getLifetime() + 1));
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void push(Entity entity) {
    }

    protected void pushEntities() {
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(ModItems.BUTTERFLY_NET)) {
            if (!this.level().isClientSide()) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ(), 5, 0.0, 0.0, 0.0, 0.05);
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 1.0f, 0.75f);
            if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            } else {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
            }
            player.addItem(new ItemStack((ItemLike)ModItems.WANDERING_NOTE.get(), 1));
            this.scheduleDeath = 3;
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        BlockPos blockpos = this.blockPosition();
        if (!(this.targetPosition == null || this.level().isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > this.level().getMinBuildHeight())) {
            this.targetPosition = null;
        }
        if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan((Position)this.position(), 2.0)) {
            this.targetPosition = BlockPos.containing((double)(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7)), (double)(this.getY() + (double)this.random.nextInt(6) - 2.0), (double)(this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7)));
        }
        double d2 = (double)this.targetPosition.getX() + 0.5 - this.getX();
        double d0 = (double)this.targetPosition.getY() + 0.1 - this.getY();
        double d1 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
        Vec3 vec3 = this.getDeltaMovement();
        Vec3 vec31 = vec3.add((Math.signum(d2) * 0.5 - vec3.x) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vec3.y) * (double)0.1f, (Math.signum(d1) * 0.5 - vec3.z) * (double)0.1f);
        this.setDeltaMovement(vec31);
        float f = (float)(Mth.atan2((double)vec31.z, (double)vec31.x) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
        this.zza = 0.5f;
        this.setYRot(this.getYRot() + f1);
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public int getTextureIndex() {
        return (Integer)this.entityData.get(TEXTURE_INDEX);
    }

    public int getLifetime() {
        return (Integer)this.entityData.get(LIFETIME);
    }

    public void setTextureIndex(int index) {
        this.entityData.set(TEXTURE_INDEX, (Object)index);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("TextureIndex")) {
            this.setTextureIndex(tag.getInt("TextureIndex"));
        }
        if (tag.contains("Lifetime")) {
            this.entityData.set(LIFETIME, (Object)tag.getInt("Lifetime"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("TextureIndex", this.getTextureIndex());
        tag.putInt("Lifetime", ((Integer)this.entityData.get(LIFETIME)).intValue());
    }
}

