/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WiseTree
extends TamableAnimal
implements GeoEntity,
TalkableEntity,
Npc {
    protected int tick = 0;
    protected int fruitTick = -1;
    protected Item fancyInstrument = null;
    public static final int DEFAULT_WET_TIME = 600;
    protected static final int DEFAULT_DROP_ANIMATION_DURATION = 80;
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final RawAnimation DROP = RawAnimation.begin().thenPlay("drop");
    protected static final EntityDataAccessor<Integer> DIALOGUE_TIMER = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> GOOD_MORNING = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> LIFE_STAGE = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> LIFE_TIME = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> TIME_WET = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> FRUIT = SynchedEntityData.defineId(WiseTree.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/wise_tree_icon.png");
    public String currentDialogue;
    public static final String RESOURCE = "dialogue.faunaandorchestra.wise_tree";
    private final AnimationController<WiseTree> wiseTreeController = new AnimationController((GeoAnimatable)this, "wise_tree_controller", 5, this::wiseTreeState).triggerableAnim("drop", DROP);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WiseTree(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DIALOGUE_TIMER, (Object)0);
        builder.define(GOOD_MORNING, (Object)true);
        builder.define(LIFE_STAGE, (Object)1);
        builder.define(LIFE_TIME, (Object)0);
        builder.define(TIME_WET, (Object)0);
        builder.define(FRUIT, (Object)false);
        super.defineSynchedData(builder);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getLifeStage() == 1) {
            return EntityDimensions.scalable((float)0.6f, (float)1.0f);
        }
        if (this.getLifeStage() == 2) {
            return EntityDimensions.scalable((float)1.5f, (float)2.25f);
        }
        return EntityDimensions.scalable((float)3.0f, (float)5.0f);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is(ModItems.GLOVE)) {
            this.setLifeStage(3);
            this.refreshDimensions();
        } else if (this.getLifeStage() == 3 && this.getDialogueTimer() == 0) {
            if (this.level().isClientSide()) {
                this.increaseDialogueTimer();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void tick() {
        if (this.fruitTick > 0) {
            if (this.fruitTick == 20) {
                Vec3 look = this.getLookAngle().normalize();
                Vec3 itemPos = this.position().add(look.scale(4.25).add(0.0, 3.0, 0.0));
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), itemPos.x, itemPos.y, itemPos.z, new ItemStack((ItemLike)ModItems.FRUIT_OF_LIFE.get())));
                if (!this.level().isClientSide()) {
                    this.level().playSound(null, this.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL);
                }
            }
            --this.fruitTick;
        } else if (this.fruitTick == 0) {
            this.fruitTick = -1;
            this.entityData.set(FRUIT, (Object)false);
        }
        if (this.tick == 10) {
            this.fancyInstrument = MusicUtil.getRandomInstrument(this.level());
            this.refreshDimensions();
        }
        if (this.getTimeWet() == 1) {
            this.fancyInstrument = MusicUtil.getRandomInstrument(this.level());
        }
        if (this.isWet() && this.tick % 20 == 0) {
            this.decreaseWetTime();
            this.increaseLifeTime();
            if (!this.level().isClientSide()) {
                float offset = switch (this.getLifeStage()) {
                    case 1 -> 0.3f;
                    case 2 -> 0.6f;
                    default -> 1.5f;
                };
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DRIPPING_WATER, this.getX(), this.getY(), this.getZ(), 5, (double)offset, (double)offset, (double)offset, 0.0);
            }
        }
        if (this.getLifeTime() == 1800) {
            if (!this.level().isClientSide()) {
                this.level().playSound(null, this.blockPosition(), ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY(), this.getZ(), 50, 3.0, 3.0, 3.0, 0.05);
            }
            if (this.getLifeStage() == 3) {
                this.entityData.set(FRUIT, (Object)true);
            }
            if (this.getLifeStage() < 3) {
                this.entityData.set(LIFE_STAGE, (Object)(this.getLifeStage() + 1));
            }
            this.entityData.set(LIFE_TIME, (Object)0);
            this.entityData.set(TIME_WET, (Object)0);
            this.tick = 0;
            this.refreshDimensions();
        }
        ++this.tick;
        super.tick();
    }

    public void tryToWater(Item item) {
        if (!this.isWet() && !((Boolean)this.entityData.get(FRUIT)).booleanValue()) {
            int quantity;
            float offset = this.getLifeStage() == 3 ? 1.75f : 0.2f;
            int n = quantity = this.getLifeStage() == 3 ? 10 : 3;
            if (item == this.fancyInstrument) {
                if (!this.level().isClientSide()) {
                    this.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_YES, SoundSource.NEUTRAL);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, this.position().x, this.getEyeY() + 1.0, this.position().z, quantity, (double)offset, (double)offset, (double)offset, 0.05);
                }
                this.setWet();
            } else if (!this.level().isClientSide()) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.position().x, this.getEyeY() + 1.0, this.position().z, quantity, (double)offset, (double)offset, (double)offset, 0.05);
                this.level().playSound(null, this.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL);
            }
        }
    }

    private <E extends GeoAnimatable> PlayState wiseTreeState(AnimationState<E> state) {
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("LifeStage", this.getLifeStage());
        compound.putInt("TimeWet", this.getTimeWet());
        compound.putInt("LifeTime", this.getLifeTime());
        compound.putBoolean("Fruit", ((Boolean)this.entityData.get(FRUIT)).booleanValue());
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("LifeStage")) {
            this.setLifeStage(compound.getInt("LifeStage"));
        }
        if (compound.contains("TimeWet")) {
            this.entityData.set(TIME_WET, (Object)compound.getInt("TimeWet"));
        }
        if (compound.contains("LifeTime")) {
            this.entityData.set(LIFE_TIME, (Object)compound.getInt("LifeTime"));
        }
        if (compound.contains("Fruit")) {
            this.entityData.set(FRUIT, (Object)compound.getBoolean("Fruit"));
        }
        super.readAdditionalSaveData(compound);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity = source.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getMainHandItem().getItem() instanceof AxeItem) {
            if (this.getLifeStage() == 3) {
                double speed = 0.25;
                double motionX = (this.level().random.nextDouble() - 0.5) * 2.0 * speed;
                double motionY = this.level().random.nextDouble() * speed + 0.1;
                double motionZ = (this.level().random.nextDouble() - 0.5) * 2.0 * speed;
                ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY() + 1.0, this.getZ(), new ItemStack((ItemLike)Items.OAK_LOG, this.random.nextInt(1, 4)), motionX, motionY, motionZ);
                item.setPos(this.getX(), this.getY() + 1.0, this.getZ());
                this.level().addFreshEntity((Entity)item);
            }
            return super.hurt(source, amount);
        }
        if (((Boolean)this.entityData.get(FRUIT)).booleanValue() && this.getLifeStage() == 3 && this.fruitTick == -1) {
            Player player2;
            this.triggerAnim("wise_tree_controller", "drop");
            this.fruitTick = 80;
            Entity entity2 = source.getEntity();
            this.level().playSound(entity2 instanceof Player ? (player2 = (Player)entity2) : null, this.blockPosition(), ModSounds.WISE_TREE_DROP.get(), SoundSource.NEUTRAL);
            return false;
        }
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + 1.25, this.getZ(), 7, 0.3, 0.15, 0.3, 0.05);
        }
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.getLifeStage() == 3 ? ModSounds.WISE_TREE_AMBIENT.get() : super.getAmbientSound();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WOOD_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOD_BREAK;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public void checkDespawn() {
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isPushable() {
        return false;
    }

    public int getLifeStage() {
        return (Integer)this.entityData.get(LIFE_STAGE);
    }

    public void setLifeStage(int stage) {
        this.entityData.set(LIFE_STAGE, (Object)stage);
    }

    @Override
    public int getTextBoxOffset() {
        return 8;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public String getRandomDialogue(Player player) {
        Object dialogue = this.currentDialogue;
        boolean goodMorning = (Boolean)this.entityData.get(GOOD_MORNING);
        if (this.getDialogueTimer() <= 5) {
            if (goodMorning) {
                dialogue = Component.translatable((String)"dialogue.faunaandorchestra.wise_tree0").getString();
            } else {
                int randomDialogue = this.random.nextInt(1, 21);
                dialogue = Component.translatable((String)(RESOURCE + randomDialogue)).getString();
            }
            if (this.getOwner() == null || !this.getOwner().is((Entity)player)) {
                dialogue = "\u00a7k" + (String)dialogue;
            }
            this.currentDialogue = dialogue;
        }
        return dialogue;
    }

    public void setWet() {
        this.entityData.set(TIME_WET, (Object)600);
    }

    public boolean isWet() {
        return (Integer)this.entityData.get(TIME_WET) > 0;
    }

    public int getTimeWet() {
        return (Integer)this.entityData.get(TIME_WET);
    }

    public int getLifeTime() {
        return (Integer)this.entityData.get(LIFE_TIME);
    }

    public void increaseLifeTime() {
        this.entityData.set(LIFE_TIME, (Object)(this.getLifeTime() + 1));
    }

    public void decreaseWetTime() {
        this.entityData.set(TIME_WET, (Object)(this.getTimeWet() - 1));
    }

    @Override
    public Pair<Integer, Integer> getIconSize() {
        return new Pair((Object)111, (Object)102);
    }

    @Override
    public Pair<Integer, Integer> getIconLocation() {
        return new Pair((Object)71, (Object)94);
    }

    @Override
    public int getDialogueTimer() {
        return (Integer)this.entityData.get(DIALOGUE_TIMER);
    }

    @Override
    public void increaseDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)(this.getDialogueTimer() + 1));
    }

    @Override
    public void resetDialogueTimer() {
        this.entityData.set(DIALOGUE_TIMER, (Object)0);
    }

    @Override
    public void setGoodMorning(boolean goodMorning) {
        this.entityData.set(GOOD_MORNING, (Object)goodMorning);
    }

    @Override
    public boolean getGoodMorning() {
        return (Boolean)this.entityData.get(GOOD_MORNING);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.wiseTreeController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

