/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.boss;

import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ComposerCanonEntity
extends Monster
implements GeoEntity {
    int ticks = 0;
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk_fast");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack_fast");
    public final AnimationController<ComposerCanonEntity> canonController = new AnimationController((GeoAnimatable)this, "composer_canon_controller", 5, this::composerCanonState).triggerableAnim("canon_attack", ATTACK).triggerableAnim("canon_spawn", SPAWN);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ComposerCanonEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    private <E extends GeoAnimatable> PlayState composerCanonState(AnimationState<E> state) {
        if (state.isMoving()) {
            state.setAnimation(WALK);
        } else {
            state.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected void checkAndPerformAttack(LivingEntity target) {
                if (this.canPerformAttack(target)) {
                    ((ComposerCanonEntity)this.mob).triggerAnim("composer_canon_controller", "canon_attack");
                    this.resetAttackCooldown();
                    this.mob.doHurtTarget((Entity)target);
                    ComposerCanonEntity.this.level().playSound(null, ComposerCanonEntity.this.blockPosition(), ModSounds.CANON_ATTACK.get(), SoundSource.NEUTRAL);
                }
            }
        });
        this.goalSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Player>(this, (Mob)this, Player.class, false, true){

            public boolean canUse() {
                return ((ComposerCanonEntity)this.mob).canAttack() && super.canUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal<Animal>(this, (Mob)this, Animal.class, false, true){

            public boolean canUse() {
                return ((ComposerCanonEntity)this.mob).canAttack() && super.canUse();
            }
        });
    }

    public void tick() {
        if (this.ticks == 1) {
            this.triggerAnim("composer_canon_controller", "canon_spawn");
            this.level().playSound(null, this.blockPosition(), ModSounds.CANON_SPAWN.get(), SoundSource.NEUTRAL);
        }
        if (this.ticks % 10 == 0 && !this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 20, (double)0.1f, (double)0.2f, (double)0.1f, 0.05);
        }
        ++this.ticks;
        super.tick();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        boolean flag = source.getDirectEntity() instanceof ThrownPotion;
        if (!source.is(DamageTypeTags.IS_PROJECTILE) && !flag) {
            boolean flag2 = super.hurt(source, amount);
            if (!this.level().isClientSide() && source.getEntity() instanceof LivingEntity) {
                this.teleport();
            }
            return flag2;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleport()) continue;
            return true;
        }
        return flag;
    }

    protected boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive()) {
            double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 32.0;
            double d1 = this.getY() + 1.0;
            double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)blockpos$mutableblockpos).blocksMotion()) {
            blockpos$mutableblockpos.move(Direction.DOWN);
        }
        BlockState blockstate = this.level().getBlockState((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.blocksMotion();
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = EventHooks.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.position();
            boolean flag2 = this.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)this));
                if (!this.isSilent()) {
                    this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                    this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.MOVEMENT_SPEED, 0.45).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 12.0);
    }

    public boolean canAttack() {
        return this.ticks >= 40;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ModSounds.CANON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.CANON_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.canonController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

