/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.boss;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.CrawlingDiscordBlock;
import net.migueel26.faunaandorchestra.effect.ModEffects;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.boss.ComposerCanonEntity;
import net.migueel26.faunaandorchestra.entity.custom.projectile.MusicNoteProjectileEntity;
import net.migueel26.faunaandorchestra.entity.custom.projectile.PhantomNoteProjectileEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.networking.ShowTitlePlayerS2CPayload;
import net.migueel26.faunaandorchestra.networking.StartAmbientMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.StopMusicS2CPayload;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TheGreatComposer
extends Mob
implements Enemy,
GeoEntity {
    protected static final int MAX_HEALTH = 300;
    protected static final int IDLE_ATTACK_COOLDOWN = 60;
    protected static final int THROW_NORMAL_ATTACK_COOLDOWN = 30;
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public static final RawAnimation DODGE = RawAnimation.begin().thenPlay("dodge");
    public static final RawAnimation NORMAL_ATTACK = RawAnimation.begin().thenPlay("attack");
    public static final RawAnimation POISON_ATTACK = RawAnimation.begin().thenPlay("attack_poison");
    public static final RawAnimation SUMMON_ATTACK = RawAnimation.begin().thenPlay("attack_summon");
    public static final RawAnimation MELEE_ATTACK = RawAnimation.begin().thenPlay("attack_melee");
    public static final RawAnimation CANON_ATTACK = RawAnimation.begin().thenPlay("attack_canon");
    public static final RawAnimation HEADLESS = RawAnimation.begin().thenPlay("headless");
    public static final RawAnimation LAUGH_ATTACK = RawAnimation.begin().thenPlay("prepare").thenLoop("laugh");
    public static final RawAnimation NOTES_ATTACK = RawAnimation.begin().thenPlay("prepare").thenLoop("attack_notes");
    public static final RawAnimation SHOCK = RawAnimation.begin().thenPlay("shock");
    public static final RawAnimation FAKE_DYING = RawAnimation.begin().thenPlay("dying");
    public static final RawAnimation WEAK = RawAnimation.begin().thenPlay("weak");
    public static final RawAnimation AWAIT = RawAnimation.begin().thenPlay("attack_await");
    public static final RawAnimation REPEL = RawAnimation.begin().thenPlay("repel");
    public static final RawAnimation FAKE_DEAD = RawAnimation.begin().thenPlay("dead");
    public static final RawAnimation IDLE_HEAD = RawAnimation.begin().thenPlay("head_idle");
    public static final RawAnimation HEAD_ATTACK = RawAnimation.begin().thenPlay("head_attack");
    public static final RawAnimation HEAD_ATTACK_LOOP = RawAnimation.begin().thenLoop("head_attack");
    public static final RawAnimation HEAD_ATTACK_MELEE = RawAnimation.begin().thenPlay("head_melee");
    public static final RawAnimation HEAD_ATTACK_CANON = RawAnimation.begin().thenPlay("head_canon");
    public static final RawAnimation HEAD_DYING = RawAnimation.begin().thenPlay("head_dying");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    public static final RawAnimation RESURRECT = RawAnimation.begin().thenPlay("resurrect");
    public final AnimationController<TheGreatComposer> composerController = new AnimationController((GeoAnimatable)this, "composer_controller", 5, this::composerState).triggerableAnim("dodge", DODGE).triggerableAnim("normal_attack", NORMAL_ATTACK).triggerableAnim("poison_attack", POISON_ATTACK).triggerableAnim("summon_attack", SUMMON_ATTACK).triggerableAnim("melee_attack", MELEE_ATTACK).triggerableAnim("canon_attack", CANON_ATTACK).triggerableAnim("repel", REPEL).triggerableAnim("fake_die", FAKE_DYING).triggerableAnim("attack_head", HEAD_ATTACK).triggerableAnim("melee_head", HEAD_ATTACK_MELEE).triggerableAnim("canon_head", HEAD_ATTACK_CANON).triggerableAnim("die", HEAD_DYING).triggerableAnim("spawn", SPAWN).triggerableAnim("resurrect", RESURRECT);
    public static EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(TheGreatComposer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static EntityDataAccessor<Integer> REPELS = SynchedEntityData.defineId(TheGreatComposer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static EntityDataAccessor<BlockPos> DEFAULT_POSITION = SynchedEntityData.defineId(TheGreatComposer.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(TheGreatComposer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected int attackCooldown = 60;
    protected int stateId;
    protected int stateTime = 0;
    protected int spawnDialogueTime = -1;
    private double velocityY = 0.0;
    int scheduleDirty = -1;
    boolean dirty = false;
    protected int consecutiveAttacks = 0;
    protected int repels = 2;
    protected float healthBefore;
    ComposerCanonEntity canonEntity;
    protected BlockPos diePos;
    private List<Player> playersListening = new ArrayList<Player>();
    protected List<? extends Holder<MobEffect>> effectsList = new ArrayList<Holder>(List.of(ModEffects.BOOGIE, MobEffects.DARKNESS, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.WEAKNESS));
    protected List<Item> instrumentList = new ArrayList<Item>(List.of((Item)ModItems.FLUTE.get(), (Item)ModItems.SAXOPHONE.get(), (Item)ModItems.KEYTAR.get(), (Item)ModItems.OBOE.get(), (Item)ModItems.BATON.get()));
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TheGreatComposer(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        this.bossEvent.setCreateWorldFog(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal(this, this, Player.class, 15.0f){

            public boolean canUse() {
                boolean canUse = !((TheGreatComposer)this.mob).isFakeDead() && !((TheGreatComposer)this.mob).isSpawning();
                return super.canUse() && canUse;
            }
        });
    }

    private <E extends GeoAnimatable> PlayState composerState(AnimationState<E> state) {
        ComposerBossState bossState = TheGreatComposer.getState(this.stateId);
        this.updateTransitionLength(bossState);
        ComposerBossState composerBossState = bossState;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORMAL_ATTACK", "LAUGH_ATTACK", "NOTE_ATTACK", "CANON_ATTACK", "WEAK", "SHOCK", "DEAD", "DYING"}, (ComposerBossState)composerBossState, n)) {
            case 0: {
                state.getController().setAnimation(AWAIT);
                break;
            }
            case 1: {
                state.getController().setAnimation(this.isFinalPhase() ? HEAD_ATTACK_LOOP : LAUGH_ATTACK);
                break;
            }
            case 2: {
                state.getController().setAnimation(this.isFinalPhase() ? HEAD_ATTACK_LOOP : NOTES_ATTACK);
                break;
            }
            case 3: {
                state.getController().setAnimation(this.isFinalPhase() ? IDLE_HEAD : HEADLESS);
                break;
            }
            case 4: {
                state.getController().setAnimation(WEAK);
                break;
            }
            case 5: {
                state.getController().setAnimation(SHOCK);
                break;
            }
            case 6: {
                state.getController().setAnimation(FAKE_DEAD);
                break;
            }
            case 7: {
                state.getController().setAnimation(HEAD_DYING);
                break;
            }
            default: {
                state.getController().setAnimation(this.isFinalPhase() ? IDLE_HEAD : IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    private void updateTransitionLength(ComposerBossState bossState) {
        if (this.dirty) {
            this.dirty = false;
            this.composerController.transitionLength(5);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
        builder.define(REPELS, (Object)2);
        builder.define(DEFAULT_POSITION, (Object)this.blockPosition());
        builder.define(PHASE, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(STATE)) {
            this.stateId = (Integer)this.entityData.get(STATE);
        }
        if (key.equals(REPELS)) {
            this.repels = (Integer)this.entityData.get(REPELS);
        }
        super.onSyncedDataUpdated(key);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.entityData.set(DEFAULT_POSITION, (Object)this.blockPosition().above(5));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (TheGreatComposer.getState(this.stateId) == ComposerBossState.DEAD) {
            player.hurt(this.damageSources().mobAttack((LivingEntity)this), 5.0f);
            this.setNewState(ComposerBossState.RESURRECTING);
            this.bossEvent.setVisible(true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.composerController);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int x = compound.getInt("X");
        int y = compound.getInt("Y");
        int z = compound.getInt("Z");
        this.entityData.set(DEFAULT_POSITION, (Object)new BlockPos(x, y, z));
        this.entityData.set(PHASE, (Object)compound.getInt("Phase"));
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("X", ((BlockPos)this.entityData.get(DEFAULT_POSITION)).getX());
        compound.putInt("Y", ((BlockPos)this.entityData.get(DEFAULT_POSITION)).getY());
        compound.putInt("Z", ((BlockPos)this.entityData.get(DEFAULT_POSITION)).getZ());
        compound.putInt("Phase", ((Integer)this.entityData.get(PHASE)).intValue());
        if (TheGreatComposer.getState(this.stateId) == ComposerBossState.RESURRECTING) {
            compound.putFloat("Health", this.getMaxHealth() / 2.0f);
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isFinalPhase()) {
            return super.getDefaultDimensions(pose).scale(1.25f, 0.75f);
        }
        if (TheGreatComposer.getState(this.stateId) == ComposerBossState.DEAD) {
            return super.getDefaultDimensions(pose).scale(2.75f, 0.75f);
        }
        return super.getDefaultDimensions(pose);
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            if (!this.isFakeDead()) {
                List nearbyPlayers = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(63.0, 32.0, 63.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE);
                ArrayList newPlayers = new ArrayList(nearbyPlayers);
                ArrayList<Player> exitPlayers = new ArrayList<Player>(this.playersListening);
                exitPlayers.removeAll(nearbyPlayers);
                newPlayers.removeAll(this.playersListening);
                for (Player player : newPlayers) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StartAmbientMusicS2CPayload(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                for (Player player : exitPlayers) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StopMusicS2CPayload(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.playersListening = nearbyPlayers;
            } else {
                this.playersListening = new ArrayList<Player>();
            }
        }
        if (this.isSpawning() && this.spawnDialogueTime == -1) {
            this.spawnDialogueTime = 0;
        } else if (this.spawnDialogueTime > -1 && this.spawnDialogueTime <= 320) {
            ++this.spawnDialogueTime;
        }
        if (this.scheduleDirty > 0) {
            --this.scheduleDirty;
        } else if (this.scheduleDirty == 0) {
            this.dirty = true;
            this.scheduleDirty = -1;
        }
        if (this.stateTime % 10 == 0 && TheGreatComposer.getState(this.stateId) != ComposerBossState.DEAD && !this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY() - (double)(this.isFinalPhase() ? 0.0f : 0.25f), this.getZ(), 5, 0.35, 0.25, 0.35, 0.0);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        ++this.stateTime;
        super.tick();
    }

    public void aiStep() {
        ComposerBossState state = TheGreatComposer.getState(this.stateId);
        if (this.isSpawning() && this.stateTime > 1 && this.stateTime < 120) {
            this.moveTo(this.getX(), this.getY() + 0.05, this.getZ());
            this.setRemainingFireTicks(0);
        }
        if (state == ComposerBossState.RESURRECTING) {
            this.refreshDimensions();
        }
        if (state == ComposerBossState.WEAK || state == ComposerBossState.DEAD) {
            this.refreshDimensions();
            double gravity = -0.08;
            double drag = 0.98;
            if (this.getBlockStateOn().is(Blocks.AIR)) {
                this.velocityY += gravity;
                this.velocityY *= drag;
                Vec3 moveVec = new Vec3(0.0, this.velocityY, 0.0);
                this.move(MoverType.SELF, moveVec);
            } else if (this.velocityY > 0.0) {
                this.velocityY = 0.0;
            }
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        ComposerBossState state = TheGreatComposer.getState(this.stateId);
        if ((Integer)this.entityData.get(PHASE) == 3 && state == ComposerBossState.IDLE) {
            this.setNewState(ComposerBossState.DEAD);
            this.stateTime = 2;
        }
        if (this.isSpawning()) {
            if (this.stateTime == 1) {
                this.triggerAnim("composer_controller", "spawn");
            }
            if (this.stateTime == 140) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.NEUTRAL);
                this.playStateSound(ModSounds.SPAWN.get());
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.position().x, this.position().y, this.position().z, 100, 0.1, 0.1, 0.1, 0.3);
                String[] fullName = Component.translatable((String)"entity.faunaandorchestra.the_great_composer").getString().split(",");
                String name = fullName[0];
                String nickname = fullName[1].substring(1);
                for (ServerPlayer player : this.bossEvent.getPlayers()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ShowTitlePlayerS2CPayload(name, nickname), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (this.stateTime == 160) {
                BlockPos pos = (BlockPos)this.entityData.get(DEFAULT_POSITION);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.position().x, this.position().y, this.position().z, 70, 0.1, 0.1, 0.1, 0.15);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 70, 0.1, 0.1, 0.1, 0.15);
                this.moveTo(pos.getX(), pos.getY(), pos.getZ());
                this.setNewState(ComposerBossState.IDLE);
                this.entityData.set(PHASE, (Object)1);
                this.attackCooldown = this.getCooldownTicks();
            }
        } else if (state == ComposerBossState.IDLE) {
            if (this.attackCooldown == 0) {
                BlockPos pos = (BlockPos)this.entityData.get(DEFAULT_POSITION);
                this.moveTo(pos.getX(), pos.getY(), pos.getZ());
                int nextAttack = this.getNextAttack();
                ComposerBossState newState = TheGreatComposer.getState(nextAttack);
                this.setNewState(newState);
            }
        } else if (state == ComposerBossState.NORMAL_ATTACK) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.ATTACK_NORMAL.get());
            }
            if (this.stateTime == 30) {
                for (Player player : this.bossEvent.getPlayers()) {
                    this.lookControl.setLookAt((Entity)player);
                    Vec3 vec3 = this.getViewVector(1.0f);
                    double d2 = player.getX() - (this.getX() + vec3.x * 4.0);
                    double d3 = player.getY(1.25) - (0.5 + this.getY(0.5));
                    double d4 = player.getZ() - (this.getZ() + vec3.z * 4.0);
                    Vec3 vec31 = new Vec3(d2, d3, d4);
                    MusicNoteProjectileEntity note = new MusicNoteProjectileEntity((LivingEntity)this, vec31.normalize(), this.level());
                    note.setPos(this.getX() + vec3.x * 1.25, this.getY(0.5), note.getZ() + vec3.z * 1.25);
                    this.level().addFreshEntity((Entity)note);
                    this.setRepels();
                }
            }
            if (this.stateTime >= 50) {
                if (this.repels == 0) {
                    this.setNewState(ComposerBossState.SHOCK);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY() + 0.5, this.getZ(), 50, 0.1, 0.75, 0.1, 0.1);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY(), this.getZ(), 50, 0.1, 0.75, 0.1, 0.1);
                } else if (this.level().getEntitiesOfClass(MusicNoteProjectileEntity.class, this.getBoundingBox().inflate(20.0)).isEmpty()) {
                    this.setNewState(ComposerBossState.IDLE);
                    this.attackCooldown = this.getCooldownTicks();
                    ++this.consecutiveAttacks;
                }
            }
        } else if (state == ComposerBossState.SHOCK) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.SHOCK.get());
                this.playStateSound(ModSounds.ELECTRIC_SHOCK.get());
            }
            if (this.stateTime == 40) {
                this.healthBefore = this.getHealth() / this.getMaxHealth();
                this.setNewState(ComposerBossState.WEAK);
            }
        } else if (state == ComposerBossState.WEAK) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.WEAK.get());
            }
            if (this.stateTime == 100 || (double)(this.healthBefore - this.getHealth() / this.getMaxHealth()) >= 0.25) {
                this.setNewState(ComposerBossState.IDLE);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY(), this.getZ(), 60, 0.1, 0.5, 0.1, 0.15);
                BlockPos newPos = (BlockPos)this.entityData.get(DEFAULT_POSITION);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, (double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ(), 60, 0.3, 1.0, 0.3, 0.1);
                this.moveTo(newPos.getX(), newPos.getY(), newPos.getZ());
                this.attackCooldown = this.getCooldownTicks();
                this.consecutiveAttacks = 0;
            }
        } else if (state == ComposerBossState.POISON_ATTACK) {
            if (this.stateTime == 1) {
                this.playStateSound(this.isFinalPhase() ? ModSounds.ATTACK_HEADLESS.get() : ModSounds.ATTACK_POISON.get());
            }
            if (this.stateTime == 45) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.WARDEN_HEARTBEAT, SoundSource.NEUTRAL);
                List entities = this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(20.0));
                for (LivingEntity entity : entities) {
                    Holder<MobEffect> nextEffect = this.effectsList.get(this.random.nextInt(0, this.effectsList.size()));
                    entity.addEffect(new MobEffectInstance(nextEffect, this.isSecondPhase() ? 280 : 200, this.isSecondPhase() ? 2 : 1));
                }
            }
            if (this.stateTime == 80) {
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks();
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.LAUGH_ATTACK) {
            Optional opPlayer;
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.PREPARE.get());
            }
            if (this.stateTime == 25 && (opPlayer = this.bossEvent.getPlayers().stream().findAny()).isPresent()) {
                ServerPlayer player = (ServerPlayer)opPlayer.get();
                int x = player.getBlockX();
                int y = player.getBlockY();
                int z = player.getBlockZ();
                Direction direction = player.getDirection();
                int rx = this.random.nextInt(12, 19);
                int rz = this.random.nextInt(12, 19);
                CrawlingDiscordBlock block = (CrawlingDiscordBlock)((Object)ModBlocks.CRAWLING_DISCORD.get());
                if (this.isSecondPhase()) {
                    block.setDifficult(true);
                }
                switch (direction) {
                    case NORTH: {
                        rz = (rz - 15) * -1;
                        rx = this.random.nextBoolean() ? (rx = rx * -1) : rx;
                        break;
                    }
                    case SOUTH: {
                        rx = this.random.nextBoolean() ? (rx = rx * -1) : rx;
                        rz -= 10;
                        break;
                    }
                    case EAST: {
                        rz = this.random.nextBoolean() ? (rz = rz * -1) : rz;
                        rx -= 10;
                        break;
                    }
                    default: {
                        rx = (rx - 15) * -1;
                        rz = this.random.nextBoolean() ? (rz = rz * -1) : rz;
                    }
                }
                int offset = 0;
                boolean sw = false;
                BlockPos currentPos = new BlockPos(x + rx, y, z + rz);
                while (!this.level().getBlockState(currentPos).isAir() || this.level().getBlockState(currentPos.below()).isAir()) {
                    currentPos = new BlockPos(x + rx, y + offset, z + rz);
                    offset = sw ? -offset : (offset <= 0 ? offset - 1 : offset + 1);
                    sw = !sw;
                }
                this.level().setBlock(currentPos, block.defaultBlockState(), 3);
                EntityType.LIGHTNING_BOLT.spawn((ServerLevel)this.level(), currentPos, MobSpawnType.MOB_SUMMONED);
                direction = this.getDirection().getOpposite();
                for (int i = 1; i <= 2; ++i) {
                    x = this.getBlockX();
                    y = this.getBlockY();
                    z = this.getBlockZ();
                    rx = this.random.nextInt(5, 9);
                    rz = this.random.nextInt(5, 9);
                    switch (direction) {
                        case NORTH: {
                            rz *= -1;
                            if (i != 2) break;
                            rx *= -1;
                            break;
                        }
                        case SOUTH: {
                            if (i != 2) break;
                            rx *= -1;
                            break;
                        }
                        case EAST: {
                            if (i != 2) break;
                            rz *= -1;
                            break;
                        }
                        default: {
                            rx *= -1;
                            if (i != 2) break;
                            rz *= -1;
                        }
                    }
                    offset = 0;
                    sw = false;
                    currentPos = new BlockPos(x + rx, y, z + rz);
                    while (!this.level().getBlockState(currentPos).isAir() || this.level().getBlockState(currentPos.below()).isAir()) {
                        currentPos = new BlockPos(x + rx, y + offset, z + rz);
                        offset = sw ? -offset : (offset <= 0 ? offset - 1 : offset + 1);
                        sw = !sw;
                    }
                    this.level().setBlock(currentPos, block.defaultBlockState(), 3);
                    EntityType.LIGHTNING_BOLT.spawn((ServerLevel)this.level(), currentPos, MobSpawnType.MOB_SUMMONED);
                }
            }
            if (this.stateTime >= 25 && (this.stateTime - 25) % 80 == 0) {
                this.level().playSound(null, this.blockPosition(), ModSounds.ATTACK_LAUGH.get(), SoundSource.NEUTRAL, 1.5f, 1.0f + (this.level().random.nextFloat() / 2.0f - 0.25f));
            }
            if (this.stateTime == CrawlingDiscordBlock.NEW_CHILD_TIME * 40 + CrawlingDiscordBlock.DIE_TIME + (this.isFinalPhase() ? 0 : 40)) {
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks() + 20;
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.SUMMON_ATTACK) {
            if (this.stateTime == 6) {
                this.playStateSound(this.isFinalPhase() ? ModSounds.ATTACK_HEADLESS.get() : ModSounds.ATTACK_SUMMON.get());
            }
            if (this.stateTime == (this.isFinalPhase() ? 30 : 65)) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.NEUTRAL);
                Direction direction = this.getDirection();
                EntityType skeletonType = this.isSecondPhase() ? EntityType.WITHER_SKELETON : EntityType.SKELETON;
                switch (direction) {
                    case NORTH: 
                    case SOUTH: {
                        this.spawnSkeleton(this.getBlockX() + 3, this.getBlockY(), this.getBlockZ(), (EntityType<? extends AbstractSkeleton>)skeletonType);
                        this.spawnSkeleton(this.getBlockX() - 3, this.getBlockY(), this.getBlockZ(), (EntityType<? extends AbstractSkeleton>)skeletonType);
                        break;
                    }
                    default: {
                        this.spawnSkeleton(this.getBlockX(), this.getBlockY(), this.getBlockZ() + 3, (EntityType<? extends AbstractSkeleton>)skeletonType);
                        this.spawnSkeleton(this.getBlockX(), this.getBlockY(), this.getBlockZ() - 3, (EntityType<? extends AbstractSkeleton>)skeletonType);
                    }
                }
                for (Player player : this.bossEvent.getPlayers()) {
                    direction = player.getDirection();
                    block23: for (int i = 1; i <= 2; ++i) {
                        float r;
                        skeletonType = this.isSecondPhase() ? ((double)(r = this.random.nextFloat()) >= 0.6 ? EntityType.SKELETON : ((double)r < 0.6 && (double)r >= 0.4 ? EntityType.WITHER_SKELETON : ((double)r < 0.4 && (double)r >= 0.2 ? EntityType.BOGGED : EntityType.STRAY))) : ((double)this.random.nextFloat() <= 0.3 ? EntityType.WITHER_SKELETON : EntityType.SKELETON);
                        int offset = i == 2 ? -4 : 4;
                        switch (direction) {
                            case NORTH: 
                            case SOUTH: {
                                this.spawnSkeleton(player.getBlockX() + offset, player.getBlockY(), player.getBlockZ(), (EntityType<? extends AbstractSkeleton>)skeletonType);
                                continue block23;
                            }
                            default: {
                                this.spawnSkeleton(player.getBlockX(), player.getBlockY(), player.getBlockZ() + offset, (EntityType<? extends AbstractSkeleton>)skeletonType);
                            }
                        }
                    }
                }
            } else if (this.stateTime == 170) {
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks() + 20;
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.MELEE_ATTACK) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.ATTACK_MELEE.get());
            }
            if (this.stateTime == 25) {
                Object x;
                Optional oPlayer = this.bossEvent.getPlayers().stream().findAny();
                if (oPlayer.isPresent() && (x = oPlayer.get()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)x;
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY(), this.getZ(), 60, 0.3, 1.0, 0.3, 0.1);
                    this.moveTo(player.getBlockX(), (float)player.getBlockY() + 0.7f, player.getBlockZ());
                }
            } else if (this.stateTime == 30) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY(), this.getZ(), 60, 0.3, 1.0, 0.3, 0.1);
            } else if (this.stateTime >= (this.isFinalPhase() ? 35 : 45) && this.stateTime < 100) {
                if (this.stateTime % 5 == 0) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.getX(), this.getY(), this.getZ(), 40, 1.0, 0.1, 1.0, 0.2);
                }
                if (this.stateTime % 10 == 2) {
                    List entities = this.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)this, this.getBoundingBox().inflate(2.0));
                    for (LivingEntity entity : entities) {
                        entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 10.0f);
                    }
                }
            } else if (this.stateTime == 105) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY(), this.getZ(), 60, 0.3, 1.0, 0.3, 0.1);
                BlockPos blockPos = (BlockPos)this.entityData.get(DEFAULT_POSITION);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 60, 0.3, 1.0, 0.3, 0.1);
                this.moveTo(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks() - 20;
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.NOTE_ATTACK) {
            int frequency;
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.PREPARE.get());
            }
            int n = frequency = this.isSecondPhase() ? 4 : 7;
            if (this.stateTime >= 40 && this.stateTime % frequency == 0) {
                for (Player player : this.bossEvent.getPlayers()) {
                    this.lookControl.setLookAt((Entity)player);
                    Vec3 vec3 = this.getViewVector(1.0f);
                    double d2 = player.getX() - (this.getX() + vec3.x * 4.0);
                    double d3 = player.getY(1.35) - (0.5 + this.getY(0.5));
                    double d4 = player.getZ() - (this.getZ() + vec3.z * 4.0);
                    Vec3 vec31 = new Vec3(d2, d3, d4);
                    PhantomNoteProjectileEntity note = new PhantomNoteProjectileEntity((LivingEntity)this, vec31.normalize(), this.level());
                    note.setPos(this.getX() + vec3.x * 1.25, this.getY(0.5) - (this.isFinalPhase() ? 0.5 : 0.0), note.getZ() + vec3.z * 1.25);
                    this.level().addFreshEntity((Entity)note);
                    this.level().playSound(null, this.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL);
                }
            }
            if (this.stateTime >= 150) {
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks();
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.CANON_ATTACK) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.ATTACK_CANON.get());
            }
            if (this.stateTime == (this.isFinalPhase() ? 30 : 90)) {
                Vec3 direction = this.getViewVector(1.0f);
                this.canonEntity = new ComposerCanonEntity(ModEntities.THE_GREAT_COMPOSER_CANON.get(), this.level());
                this.canonEntity.setYBodyRot(this.getYRot());
                this.canonEntity.setYHeadRot(this.getYHeadRot());
                this.canonEntity.setPos(this.getX(), this.getY() - 1.25, this.getZ());
                this.level().addFreshEntity((Entity)this.canonEntity);
            }
            if (!(this.stateTime <= 95 || this.stateTime < 1000 && this.canonEntity != null && this.canonEntity.isAlive())) {
                if (this.canonEntity != null && this.canonEntity.isAlive()) {
                    this.canonEntity.discard();
                }
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks();
                ++this.consecutiveAttacks;
            }
        } else if (state == ComposerBossState.FAKE_DYING) {
            if (this.stateTime == 1) {
                BlockPos pos = (BlockPos)this.entityData.get(DEFAULT_POSITION);
                this.moveTo(pos.getX(), pos.getY(), pos.getZ());
                this.entityData.set(PHASE, (Object)3);
                this.trigger("fake_die", false);
                this.level().playSound(null, this.blockPosition(), ModSounds.FAKE_DYING.get(), SoundSource.NEUTRAL);
                this.level().playSound(null, this.blockPosition(), ModSounds.ELECTRIC_SHOCK.get(), SoundSource.NEUTRAL);
            } else if (this.stateTime >= 1 && this.stateTime < 100) {
                if (this.stateTime % 5 == 0) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY() + 0.75, this.getZ(), 50, 0.1, 0.5, 0.1, 0.15);
                }
            } else if (this.stateTime == 100) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 0.75, this.getZ(), 50, 0.1, 0.5, 0.1, 0.25);
                this.setNewState(ComposerBossState.DEAD);
                this.attackCooldown = this.getCooldownTicks();
            }
        } else if (state == ComposerBossState.RESURRECTING) {
            if (this.stateTime == 1) {
                this.playStateSound(ModSounds.RESURRECT.get());
            }
            if (this.getHealth() < this.getMaxHealth() / 2.0f - 1.0f) {
                if (this.stateTime == 1) {
                    this.triggerAnim("composer_controller", "resurrect");
                }
                if (this.stateTime > 15) {
                    this.setHealth(this.getHealth() + 1.0f);
                    this.moveTo(this.getX(), this.getY() + 0.05, this.getZ());
                }
                this.entityData.set(PHASE, (Object)4);
                if (this.stateTime == 97) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.position().x, this.position().y, this.position().z, 70, 0.1, 0.1, 0.1, 0.15);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.position().x, this.position().y, this.position().z, 100, 0.1, 0.1, 0.1, 0.3);
                }
            } else {
                this.setNewState(ComposerBossState.IDLE);
                this.attackCooldown = this.getCooldownTicks();
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.position().x, this.position().y, this.position().z, 70, 0.1, 0.1, 0.1, 0.15);
                for (Player player : this.bossEvent.getPlayers()) {
                    player.displayClientMessage((Component)Component.translatable((String)"dialogue.faunaandorchestra.the_great_composer2"), true);
                }
            }
        } else if (state == ComposerBossState.DYING) {
            if (this.stateTime == 1) {
                for (ServerPlayer player : this.bossEvent.getPlayers()) {
                    ((CustomSimpleTrigger)((Object)ModAdvancements.KILL_COMPOSER.get())).trigger(player);
                }
                this.diePos = this.blockPosition();
                this.level().playSound(null, this.blockPosition(), ModSounds.DYING.get(), SoundSource.NEUTRAL);
                this.level().playSound(null, this.blockPosition(), ModSounds.ELECTRIC_SHOCK.get(), SoundSource.NEUTRAL);
            } else if (this.stateTime == 157) {
                this.level().explode(null, this.getX(), this.getY(), this.getZ(), 5.0f, Level.ExplosionInteraction.TNT);
            } else if (this.stateTime == 160) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 0.2, this.getZ(), 70, 0.1, 0.1, 0.1, 0.25);
                ItemEntity baton = new ItemEntity(this.level(), this.getX() + 0.2, this.getY(), this.getZ() + 0.2, new ItemStack((ItemLike)ModItems.LEGENDARY_BATON.get(), 1));
                ItemEntity head = new ItemEntity(this.level(), this.getX() - 0.2, this.getY(), this.getZ() - 0.2, new ItemStack((ItemLike)ModItems.THE_GREAT_HEAD_ITEM.get(), 1));
                this.level().addFreshEntity((Entity)baton);
                this.level().addFreshEntity((Entity)head);
                ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)100);
                this.discard();
            }
            if (this.stateTime == 26) {
                double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 4.0;
                double d1 = this.getY() - 1.0;
                double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 4.0;
                this.moveTo(d0, d1, d2);
            } else if (this.stateTime == 54) {
                double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 4.0;
                double d1 = this.getY() + 2.0;
                double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 4.0;
                this.moveTo(d0, d1, d2);
            } else if (this.stateTime == 85) {
                double d0 = this.getX() + (this.random.nextDouble() - 0.5) * 4.0;
                double d1 = this.getY() - 2.0;
                double d2 = this.getZ() + (this.random.nextDouble() - 0.5) * 4.0;
                this.moveTo(d0, d1, d2);
            } else if (this.stateTime == 112) {
                this.moveTo(this.diePos.getX(), this.diePos.getY(), this.diePos.getZ());
            }
            if (this.stateTime % 5 == 0) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, this.getX(), this.getY() + 0.2, this.getZ(), 20, 0.1, 0.1, 0.1, 0.15);
            }
        }
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    private void playStateSound(SoundEvent soundEvent) {
        this.level().playSound(null, this.blockPosition(), soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private int getNextAttack() {
        int nextAttack = -1;
        int canAttack = 0;
        if (this.consecutiveAttacks < this.getMinAttacks() || this.isFinalPhase()) {
            canAttack = 1;
        }
        if (this.isSecondPhase()) {
            if ((Integer)this.entityData.get(PHASE) <= 1) {
                nextAttack = 7;
                this.entityData.set(PHASE, (Object)2);
            } else {
                int repeats = 0;
                if (this.consecutiveAttacks > this.getMaxPity()) {
                    repeats = (int)(1.0f + (float)(this.consecutiveAttacks - this.getMaxPity()) * 1.25f);
                }
                for (int i = 0; i <= repeats && nextAttack != 1; ++i) {
                    nextAttack = this.level().getRandom().nextInt(1 + canAttack, 8);
                }
            }
        } else {
            int repeats = 0;
            if (this.consecutiveAttacks > this.getMaxPity()) {
                repeats = (int)(1.0f + (float)(this.consecutiveAttacks - this.getMaxPity()) * 1.25f);
            }
            for (int i = 0; i <= repeats && nextAttack != 1; ++i) {
                nextAttack = this.level().getRandom().nextInt(1 + canAttack, 7);
            }
        }
        return nextAttack;
    }

    private void spawnSkeleton(int x, int y, int z, EntityType<? extends AbstractSkeleton> skeletonType) {
        ItemStack instrument = this.getRandomInstrument();
        AbstractSkeleton skeleton = (AbstractSkeleton)skeletonType.spawn((ServerLevel)this.level(), new BlockPos(x, y, z), MobSpawnType.MOB_SUMMONED);
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, (double)x, (double)y, (double)z, 50, 0.1, 0.5, 0.1, 0.1);
        skeleton.setItemSlot(EquipmentSlot.MAINHAND, instrument);
        skeleton.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
    }

    private void setNewState(ComposerBossState newState) {
        switch (newState.ordinal()) {
            case 1: {
                this.trigger("normal_attack", false);
                break;
            }
            case 2: {
                this.trigger("poison_attack", false);
                break;
            }
            case 4: {
                this.trigger("summon_attack", false);
                break;
            }
            case 5: {
                this.trigger("melee_attack", false);
                break;
            }
            case 7: {
                this.trigger("canon_attack", false);
                break;
            }
            case 3: {
                break;
            }
        }
        this.setStateId(newState);
        if (this.isFinalPhase() && newState != ComposerBossState.DYING) {
            this.teleport();
        }
        this.stateTime = 0;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypes.FALL)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource source, float amount) {
        ComposerBossState state = TheGreatComposer.getState(this.stateId);
        if (this.isFinalPhase() && state != ComposerBossState.CANON_ATTACK && !this.isInvalidState(state) && this.getHealth() - amount > 0.0f) {
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            boolean flag = source.getDirectEntity() instanceof ThrownPotion;
            if (!flag) {
                boolean flag2 = super.hurt(source, amount);
                if (!this.level().isClientSide() && source.getEntity() instanceof LivingEntity) {
                    this.teleport();
                }
                return flag2;
            }
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return flag;
        }
        if (this.getHealth() - amount <= 0.0f && !this.isInvalidState(state)) {
            if ((Integer)this.entityData.get(PHASE) <= 2) {
                this.setNewState(ComposerBossState.FAKE_DYING);
                this.attackCooldown = 60;
                this.bossEvent.setVisible(false);
                this.setHealth(0.01f);
                return true;
            }
            if ((Integer)this.entityData.get(PHASE) >= 3) {
                this.setNewState(ComposerBossState.DYING);
                this.setHealth(0.01f);
                return true;
            }
        } else {
            if (state == ComposerBossState.DEAD && !source.getMsgId().equalsIgnoreCase("generickill")) {
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.displayClientMessage((Component)Component.translatable((String)"text.faunaandorchestra.pick_up_composer"), true);
                }
                return false;
            }
            if (this.isInvalidState(state) || this.isSpawning()) {
                return false;
            }
            if (state != ComposerBossState.WEAK && !source.getMsgId().equalsIgnoreCase("generickill")) {
                this.composerController.transitionLength(1);
                this.trigger("dodge", true);
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.displayClientMessage((Component)Component.translatable((String)"dialogue.faunaandorchestra.the_great_composer3"), true);
                }
                if (!this.level().isClientSide()) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + 1.25, this.getZ(), 7, 0.3, 0.15, 0.3, 0.05);
                }
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    protected boolean teleport() {
        Optional player = this.bossEvent.getPlayers().stream().findAny();
        if (!this.level().isClientSide() && this.isAlive() && player.isPresent()) {
            BlockPos pos = ((ServerPlayer)player.get()).blockPosition();
            double d0 = (double)pos.getX() + (this.random.nextDouble() - 0.5) * 32.0;
            double d1 = pos.getY() + this.random.nextInt(2, 5);
            double d2 = (double)pos.getZ() + (this.random.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (!this.level().getBlockState((BlockPos)mutableBlockPos).isAir()) {
            mutableBlockPos.move(Direction.UP);
        }
        BlockState blockstate = this.level().getBlockState((BlockPos)mutableBlockPos);
        boolean flag1 = blockstate.getFluidState().is(FluidTags.WATER);
        if (!flag1) {
            this.moveTo(mutableBlockPos.getX(), mutableBlockPos.getY(), mutableBlockPos.getZ());
            this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
            this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static ComposerBossState getState(int id) {
        if (id == -1) {
            System.err.println("Tried to get an invalid state!");
        }
        return switch (id) {
            case 1 -> ComposerBossState.NORMAL_ATTACK;
            case 2 -> ComposerBossState.POISON_ATTACK;
            case 3 -> ComposerBossState.LAUGH_ATTACK;
            case 4 -> ComposerBossState.SUMMON_ATTACK;
            case 5 -> ComposerBossState.MELEE_ATTACK;
            case 6 -> ComposerBossState.NOTE_ATTACK;
            case 7 -> ComposerBossState.CANON_ATTACK;
            case 8 -> ComposerBossState.SHOCK;
            case 9 -> ComposerBossState.WEAK;
            case 10 -> ComposerBossState.DEAD;
            case 11 -> ComposerBossState.FAKE_DYING;
            case 12 -> ComposerBossState.RESURRECTING;
            case 13 -> ComposerBossState.DYING;
            default -> ComposerBossState.IDLE;
        };
    }

    public void setStateId(ComposerBossState state) {
        int id = switch (state.ordinal()) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5 -> 5;
            case 6 -> 6;
            case 7 -> 7;
            case 8 -> 8;
            case 9 -> 9;
            case 10 -> 10;
            case 11 -> 11;
            case 12 -> 12;
            case 13 -> 13;
            default -> 0;
        };
        this.entityData.set(STATE, (Object)id);
    }

    public boolean isBusy() {
        return TheGreatComposer.getState(this.stateId) != ComposerBossState.IDLE;
    }

    public void trigger(String animation, boolean dirty) {
        if (dirty) {
            this.scheduleDirty = 5;
        } else {
            this.composerController.transitionLength(5);
        }
        if (this.isFinalPhase() && TheGreatComposer.getState(this.stateId) != ComposerBossState.DYING) {
            switch (animation) {
                case "melee_attack": {
                    animation = "melee_head";
                    break;
                }
                case "canon_attack": {
                    animation = "canon_head";
                    break;
                }
                default: {
                    animation = "attack_head";
                }
            }
        }
        this.triggerAnim("composer_controller", animation);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        if (!this.isDeadOrDying()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.faunaandorchestra.leave_composer"), true);
            player.playNotifySound(SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.bossEvent.removePlayer(player);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isNoGravity() {
        return true;
    }

    protected boolean isInvalidState(ComposerBossState state) {
        return state == ComposerBossState.DYING || state == ComposerBossState.FAKE_DYING || state == ComposerBossState.RESURRECTING || state == ComposerBossState.DEAD;
    }

    public boolean isSecondPhase() {
        return (double)(this.getHealth() / this.getMaxHealth()) <= 0.5;
    }

    public int getRepels() {
        return (Integer)this.entityData.get(REPELS);
    }

    public void decreaseRepels() {
        --this.repels;
        this.entityData.set(REPELS, (Object)this.repels);
    }

    protected void setRepels() {
        float percHealth = this.getHealth() / this.getMaxHealth();
        this.repels = (double)percHealth > 0.75 ? 2 : ((double)percHealth >= 0.5 && (double)percHealth < 0.75 ? 4 : ((double)percHealth >= 0.25 && (double)percHealth < 0.5 ? 6 : 8));
        this.entityData.set(REPELS, (Object)this.repels);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WARDEN_HURT;
    }

    public void setSpawnPos(BlockPos pos) {
        this.entityData.set(DEFAULT_POSITION, (Object)pos.above(5));
    }

    public boolean isFakeDead() {
        return (Integer)this.entityData.get(PHASE) == 3;
    }

    public boolean isFinalPhase() {
        return (Integer)this.entityData.get(PHASE) == 4;
    }

    public boolean isSpawning() {
        return (Integer)this.entityData.get(PHASE) == 0;
    }

    public int getSpawnTime() {
        return this.spawnDialogueTime;
    }

    public ComposerBossState getState() {
        return TheGreatComposer.getState(this.stateId);
    }

    public boolean shouldDisplayDialogue() {
        return this.spawnDialogueTime > -1;
    }

    public void resetDialogueTimer() {
        this.spawnDialogueTime = -1;
    }

    public ItemStack getRandomInstrument() {
        Item item = this.instrumentList.get(this.random.nextInt(this.instrumentList.size()));
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setDamageValue(20);
        return stack;
    }

    public int getCooldownTicks() {
        if (this.isFinalPhase()) {
            return 30;
        }
        if (this.isSecondPhase()) {
            return 40;
        }
        return 60;
    }

    public int getMinAttacks() {
        return this.isSecondPhase() ? 4 : 2;
    }

    public int getMaxPity() {
        return this.isSecondPhase() ? 7 : 5;
    }

    public static enum ComposerBossState {
        IDLE,
        NORMAL_ATTACK,
        POISON_ATTACK,
        LAUGH_ATTACK,
        SUMMON_ATTACK,
        MELEE_ATTACK,
        NOTE_ATTACK,
        CANON_ATTACK,
        SHOCK,
        WEAK,
        DEAD,
        FAKE_DYING,
        RESURRECTING,
        DYING;

    }
}

