/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.EnumSet;
import net.migueel26.faunaandorchestra.entity.custom.KoalaEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.migueel26.faunaandorchestra.entity.custom.SproutlingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FaunaRandomLookAroundGoal
extends Goal {
    private final Mob mob;
    private double relX;
    private double relZ;
    private int lookTime;

    public FaunaRandomLookAroundGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        boolean condition;
        boolean bl = condition = this.mob.getRandom().nextFloat() < 0.02f;
        if (condition) {
            Fauna mobType = Fauna.valueOf(this.mob.getClass().getSuperclass().getSimpleName());
            if (mobType != Fauna.MusicalEntity) {
                mobType = Fauna.valueOf(this.mob.getClass().getSimpleName());
            }
            switch (mobType.ordinal()) {
                case 0: {
                    condition = !((MusicalEntity)this.mob).isPlayingInstrument();
                    break;
                }
                case 3: {
                    condition = !((QuirkyFrogEntity)this.mob).isConducting() && !((QuirkyFrogEntity)this.mob).isSinging();
                    break;
                }
                case 4: {
                    condition = !((KoalaEntity)this.mob).isKoalaSleeping();
                    break;
                }
                case 5: {
                    condition = !((SproutlingEntity)this.mob).isSinging();
                }
            }
        }
        return condition;
    }

    public boolean canContinueToUse() {
        return this.lookTime >= 0;
    }

    public void start() {
        double d0 = Math.PI * 2 * this.mob.getRandom().nextDouble();
        this.relX = Math.cos(d0);
        this.relZ = Math.sin(d0);
        this.lookTime = 20 + this.mob.getRandom().nextInt(20);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        --this.lookTime;
        this.mob.getLookControl().setLookAt(this.mob.getX() + this.relX, this.mob.getEyeY(), this.mob.getZ() + this.relZ);
    }

    public static enum Fauna {
        MusicalEntity,
        ConductorEntity,
        AgeableMob,
        QuirkyFrogEntity,
        KoalaEntity,
        SproutlingEntity;

    }
}

