/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.Orion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class FaustFindOrionGoal
extends Goal {
    protected final Faust faust;
    protected Orion orion;

    public FaustFindOrionGoal(Faust faust) {
        this.faust = faust;
    }

    public boolean canUse() {
        if (this.orion == null || this.orion.isDeadOrDying()) {
            this.faust.setOrion(null);
            Orion orion = (Orion)this.faust.level().getNearestEntity(Orion.class, TargetingConditions.DEFAULT, (LivingEntity)this.faust, this.faust.getX(), this.faust.getY(), this.faust.getZ(), this.faust.getBoundingBox().inflate(10.0));
            if (orion != null) {
                this.orion = orion;
                this.faust.setOrion(orion);
                orion.setFaust(this.faust);
            }
        } else if ((double)this.faust.distanceTo((Entity)this.orion) <= 2.5) {
            this.faust.setPlaying(true);
            this.orion.setPlaying(true);
        }
        return this.orion != null && (double)this.faust.distanceTo((Entity)this.orion) > 2.5 && this.faust.getLastDamageSource() == null && this.orion.getLastDamageSource() == null;
    }

    public boolean canContinueToUse() {
        return this.faust.getNavigation().isInProgress() || this.orion.getNavigation().isInProgress();
    }

    public void start() {
        Vec3 middle = this.faust.position().add(this.orion.position()).scale(0.5);
        this.faust.getNavigation().moveTo(middle.x, middle.y, middle.z, 1.0);
        this.orion.getNavigation().moveTo(middle.x, middle.y, middle.z, 1.0);
        this.faust.setPlaying(false);
        this.orion.setPlaying(false);
        super.start();
    }

    public void stop() {
        super.stop();
        this.faust.setPlaying(true);
        this.orion.setPlaying(true);
    }
}

