/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import net.migueel26.faunaandorchestra.entity.custom.KoalaEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class KoalaRandomChangeStanceGoal
extends Goal {
    private final int threshold = 500;
    private final KoalaEntity koala;
    private final float probability;
    private int timeSpentInCurrentStance = 0;

    public KoalaRandomChangeStanceGoal(KoalaEntity koala, float probability) {
        this.koala = koala;
        this.probability = probability / 20.0f;
    }

    public boolean canUse() {
        ++this.timeSpentInCurrentStance;
        return this.koala.getRandom().nextFloat() < this.probability * (float)this.timeSpentInCurrentStance / 200.0f && !this.koala.isInWater() && !this.koala.isKoalaSleeping() && this.koala.getNavigation().isDone() && this.timeSpentInCurrentStance > 500;
    }

    public boolean canContinueToUse() {
        boolean flag;
        boolean bl = flag = this.timeSpentInCurrentStance < 500;
        if (!flag) {
            flag = this.koala.getRandom().nextFloat() > this.probability * (float)this.timeSpentInCurrentStance / 200.0f;
        }
        return flag && !this.koala.isInWater() && this.koala.getNavigation().isDone();
    }

    public void start() {
        this.koala.getNavigation().stop();
        if (!this.koala.isSitting()) {
            this.koala.sitDown();
        }
        this.timeSpentInCurrentStance = 0;
    }

    public void stop() {
        this.koala.getNavigation().stop();
        if (!this.koala.isKoalaSleeping()) {
            this.koala.standUp();
        }
        this.timeSpentInCurrentStance = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return super.requiresUpdateEveryTick();
    }

    public void tick() {
        ++this.timeSpentInCurrentStance;
    }
}

