/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.Orion;
import net.migueel26.faunaandorchestra.entity.custom.TalkableEntity;
import net.migueel26.faunaandorchestra.util.ModSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class RingtailsRunAwayGoal
extends PanicGoal {
    protected int runTicks;
    protected BlockPos tipCasePos;

    public RingtailsRunAwayGoal(PathfinderMob mob, double speedModifier) {
        super(mob, speedModifier);
    }

    public boolean canUse() {
        boolean tipCaseBroken = false;
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Faust) {
            Faust faust = (Faust)pathfinderMob;
            this.tipCasePos = faust.getTipCasePos();
        }
        if (this.tipCasePos != null && this.mob.level().getBlockState(this.tipCasePos).is(Blocks.AIR)) {
            tipCaseBroken = true;
        }
        return super.canUse() || tipCaseBroken;
    }

    public void start() {
        Faust faust;
        BlockState state = null;
        super.start();
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof Faust && (faust = (Faust)pathfinderMob).getOrion() != null) {
            this.findRandomPosition();
            faust.getOrion().getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
            faust.getOrion().setPlaying(false);
            faust.setPlaying(false);
            this.tipCasePos = faust.getTipCasePos();
        } else {
            Orion orion;
            pathfinderMob = this.mob;
            if (pathfinderMob instanceof Orion && (orion = (Orion)pathfinderMob).getFaust() != null) {
                this.findRandomPosition();
                orion.getFaust().getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
                orion.getFaust().setPlaying(false);
                orion.setPlaying(false);
                this.tipCasePos = orion.getFaust().getTipCasePos();
            }
        }
        if (this.tipCasePos != null) {
            state = this.mob.level().getBlockState(this.tipCasePos);
        }
        if (this.tipCasePos != null && state.is(ModBlocks.TIP_CASE)) {
            this.mob.level().setBlock(this.tipCasePos, Blocks.AIR.defaultBlockState(), 3);
        }
        this.runTicks = 10;
    }

    public void tick() {
        --this.runTicks;
        super.tick();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() || this.runTicks > 0;
    }

    public void stop() {
        Player player;
        Faust faust = null;
        Orion orion = null;
        super.stop();
        ServerLevel level = (ServerLevel)this.mob.level();
        LivingEntity entity = this.mob.getLastHurtByMob();
        if (this.mob instanceof Faust) {
            orion = ((Faust)this.mob).getOrion();
        } else {
            faust = ((Orion)this.mob).getFaust();
        }
        if (orion != null) {
            level.sendParticles((ParticleOptions)ParticleTypes.POOF, orion.getX(), orion.getY(), orion.getZ(), 30, 0.1, 0.5, 0.1, 0.3);
            if (entity instanceof Player) {
                player = (Player)entity;
                ModSavedData.saveConfidence(level, orion, player.getUUID(), -1);
            }
            orion.remove(Entity.RemovalReason.DISCARDED);
        }
        if (faust != null) {
            level.sendParticles((ParticleOptions)ParticleTypes.POOF, faust.getX(), faust.getY(), faust.getZ(), 30, 0.1, 0.5, 0.1, 0.3);
            if (entity instanceof Player) {
                player = (Player)entity;
                ModSavedData.saveConfidence(level, faust, player.getUUID(), -1);
            }
            faust.remove(Entity.RemovalReason.DISCARDED);
        }
        level.sendParticles((ParticleOptions)ParticleTypes.POOF, this.mob.getX(), this.mob.getY(), this.mob.getZ(), 30, 0.1, 0.5, 0.1, 0.3);
        if (entity instanceof Player) {
            player = (Player)entity;
            ModSavedData.saveConfidence(level, (TalkableEntity)this.mob, player.getUUID(), -1);
        }
        this.mob.remove(Entity.RemovalReason.DISCARDED);
    }
}

