/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import java.util.List;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.SproutlingEntity;
import net.migueel26.faunaandorchestra.entity.custom.WiseTree;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SingingSproutlingGatherGoal
extends Goal {
    private SproutlingEntity director;
    int index;
    protected int tick;

    public SingingSproutlingGatherGoal(SproutlingEntity director) {
        this.director = director;
    }

    public boolean canUse() {
        return this.director.getDirSproutlings() != null && this.director.getDirCentroid() != null;
    }

    public boolean canContinueToUse() {
        return this.canUse() && !this.director.isDeadOrDying();
    }

    public void start() {
        this.tick = 0;
        this.index = 0;
        this.director.getDirSproutlings().forEach(sproutling -> sproutling.setSinging(true));
        super.start();
    }

    public void tick() {
        if (this.tick >= 140 && this.tick <= 198) {
            SproutlingEntity chorister = this.director.getDirSproutlings().get(this.index < 6 ? this.index : 5);
            if (this.tick == 140) {
                this.sing(chorister);
                ++this.index;
            } else if (this.tick == 150 && !this.director.level().isClientSide()) {
                this.director.level().playSound(null, this.director.blockPosition(), ModSounds.SPROUTLING_SONG.get(), SoundSource.NEUTRAL);
            }
            if (this.tick == 150) {
                this.sing(chorister);
                ++this.index;
            }
            if (this.tick == 157) {
                this.sing(chorister);
                ++this.index;
            }
            if (this.tick == 179) {
                this.sing(chorister);
                ++this.index;
            }
            if (this.tick == 188) {
                this.sing(chorister);
                ++this.index;
            }
            if (this.tick == 198) {
                this.sing(chorister);
                ++this.index;
            }
        }
        if (this.tick == 220) {
            Vec3 pos = this.director.getDirCentroid();
            List<SproutlingEntity> sproutlings = this.director.getDirSproutlingsMinusDir();
            sproutlings.forEach(sproutling -> sproutling.getNavigation().moveTo(pos.x, pos.y, pos.z, 1.0));
            this.director.getNavigation().moveTo(pos.x, pos.y, pos.z, 1.0);
        }
        if (this.tick == 280) {
            if (!this.director.level().isClientSide()) {
                Vec3 centroid = this.director.getDirCentroid();
                ((ServerLevel)this.director.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, centroid.x, centroid.y, centroid.z, 100, 0.25, 0.25, 0.25, 0.3);
                this.director.level().playSound(null, BlockPos.containing((Position)centroid), ModSounds.SUCCESSFUL_TAME.get(), SoundSource.NEUTRAL);
            }
            WiseTree wiseTree = new WiseTree(ModEntities.WISE_TREE.get(), this.director.level());
            wiseTree.setOwnerUUID(this.director.getDirOwnerUUID());
            wiseTree.setPos(this.director.getDirCentroid());
            wiseTree.setTame(true, false);
            Player player = this.director.level().getPlayerByUUID(this.director.getDirOwnerUUID());
            if (player != null && player.isAlive()) {
                wiseTree.lookAt(EntityAnchorArgument.Anchor.FEET, player.position());
                if (!this.director.level().isClientSide()) {
                    ((CustomSimpleTrigger)((Object)ModAdvancements.WISE_TREE.get())).trigger((ServerPlayer)player);
                }
            }
            this.director.level().addFreshEntity((Entity)wiseTree);
            this.director.getDirSproutlingsMinusDir().forEach(Entity::discard);
            this.director.discard();
        }
        ++this.tick;
        super.tick();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void sing(SproutlingEntity sproutling) {
        sproutling.triggerAnim("sproutling_controller", "sing_trigger");
        if (!sproutling.level().isClientSide()) {
            ((ServerLevel)sproutling.level()).sendParticles((ParticleOptions)ParticleTypes.NOTE, sproutling.getX(), sproutling.getY() + 0.5, sproutling.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

