/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CustomSpawnEggItem
extends Item {
    List<EntityType<? extends AgeableMob>> musicians;

    @SafeVarargs
    public CustomSpawnEggItem(Item.Properties properties, EntityType<? extends AgeableMob> ... musicians) {
        super(properties);
        this.musicians = Arrays.stream(musicians).toList();
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockpos1 = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        for (EntityType<? extends AgeableMob> entityType : this.musicians) {
            entityType.spawn((ServerLevel)level, itemstack, context.getPlayer(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        }
        itemstack.shrink(1);
        level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = CustomSpawnEggItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            for (EntityType<? extends AgeableMob> entitytype : this.musicians) {
                entitytype.spawn((ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            }
            itemstack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, blockpos);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

