/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.entity.custom.decorative.RingtailsPosterEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RingtailsPosterItem
extends Item {
    public static ResourceKey<PaintingVariant> variantKey = ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"ringtails_poster"));

    public RingtailsPosterItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.ringtails_poster.desc").withStyle(ChatFormatting.DARK_GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        Direction facing = context.getClickedFace();
        if (facing.getAxis().isVertical()) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            RingtailsPosterEntity painting = new RingtailsPosterEntity(level, pos, facing, (Holder<PaintingVariant>)level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getHolderOrThrow(variantKey));
            if (painting.survives()) {
                level.addFreshEntity((Entity)painting);
                if (context.getPlayer() != null && !context.getPlayer().getAbilities().instabuild) {
                    context.getItemInHand().shrink(1);
                }
                painting.playPlacementSound();
                return InteractionResult.SUCCESS;
            }
            painting.discard();
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }
}

