/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.mixins.client;

import com.mojang.blaze3d.audio.SoundBuffer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.migueel26.faunaandorchestra.mixins.interfaces.IChannelMixin;
import net.migueel26.faunaandorchestra.mixins.interfaces.ISoundEngineMixin;
import net.migueel26.faunaandorchestra.sound.custom.BossSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.FrogSongSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.InstrumentSoundInstance;
import net.migueel26.faunaandorchestra.sound.custom.TravellingMusicianSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public class MixinSoundEngine
implements ISoundEngineMixin {
    @Shadow
    @Final
    private SoundBufferLibrary soundBuffers;
    @Shadow
    @Final
    private List<TickableSoundInstance> tickingSounds;

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getCompleteBuffer(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void handleMusicalOfffsetSounds(SoundInstance soundInstance, CallbackInfo ci, WeighedSoundEvents $$1x, ResourceLocation $$2x, Sound sound, float $$4x, float $$5x, SoundSource soundSource, float $$7x, float $$8x, SoundInstance.Attenuation attenuation, boolean $$10x, Vec3 $$11x, boolean $$14, boolean $$15, CompletableFuture $$16, ChannelAccess.ChannelHandle channelaccess$channelhandle) {
        if (soundInstance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance instrumentSoundInstance = (InstrumentSoundInstance)soundInstance;
            this.playInstrument(instrumentSoundInstance, channelaccess$channelhandle);
            ci.cancel();
        }
    }

    @Unique
    private void playInstrument(InstrumentSoundInstance soundInstance, ChannelAccess.ChannelHandle channelAccess) {
        Sound sound = soundInstance.getSound();
        this.soundBuffers.getCompleteBuffer(sound.getPath()).thenAccept(soundBuffer -> channelAccess.execute(channel -> {
            if (soundInstance.getTicksOffset() == null) {
                Optional<Integer> sourceOffset = this.tickingSounds.stream().filter(InstrumentSoundInstance.class::isInstance).map(soundInst -> ((InstrumentSoundInstance)((Object)((Object)((Object)soundInst)))).getSourceID()).findAny();
                if (sourceOffset.isPresent()) {
                    ((IChannelMixin)channel).faunaSetByteOffset((SoundInstance)soundInstance, (SoundBuffer)soundBuffer, sourceOffset.get());
                } else {
                    ((IChannelMixin)channel).faunaSetTickOffset((SoundInstance)soundInstance, (SoundBuffer)soundBuffer, 0);
                }
            } else {
                ((IChannelMixin)channel).faunaSetTickOffset((SoundInstance)soundInstance, (SoundBuffer)soundBuffer, soundInstance.getTicksOffset());
            }
            channel.play();
        }));
        this.tickingSounds.add((TickableSoundInstance)soundInstance);
    }

    @Override
    public void faunaStopMusic(UUID entityUUID) {
        this.tickingSounds.stream().filter(InstrumentSoundInstance.class::isInstance).map(InstrumentSoundInstance.class::cast).filter(sound -> sound.getEntity().getUUID().equals(entityUUID)).forEach(InstrumentSoundInstance::stopSound);
    }

    @Override
    public void faunaStopFrogMusic(UUID entityUUID) {
        this.tickingSounds.stream().filter(FrogSongSoundInstance.class::isInstance).map(FrogSongSoundInstance.class::cast).filter(sound -> sound.getFrogUUID().equals(entityUUID)).forEach(FrogSongSoundInstance::stopSound);
    }

    @Override
    public void faunaStopTravellingMusicianMusic(UUID entityUUID) {
        this.tickingSounds.stream().filter(TravellingMusicianSoundInstance.class::isInstance).map(TravellingMusicianSoundInstance.class::cast).filter(sound -> sound.getUUID().equals(entityUUID)).forEach(TravellingMusicianSoundInstance::stopSound);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean faunaIsThereAnOrchestra() {
        if (this.tickingSounds.stream().anyMatch(InstrumentSoundInstance.class::isInstance)) return true;
        if (this.tickingSounds.stream().anyMatch(TravellingMusicianSoundInstance.class::isInstance)) return true;
        if (!this.tickingSounds.stream().anyMatch(BossSoundInstance.class::isInstance)) return false;
        return true;
    }
}

