/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.networking;

import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.entity.TipCaseBlockEntity;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.networking.RestartOrchestraMusicC2SPayload;
import net.migueel26.faunaandorchestra.networking.RestartOrchestraMusicS2CPayload;
import net.migueel26.faunaandorchestra.networking.SyncTipCaseOwnerPayloadC2S;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleEmpty(CustomPacketPayload payload, IPayloadContext iPayloadContext) {
    }

    public static void handleRestartOrchestraOnNetwork(RestartOrchestraMusicC2SPayload payload, IPayloadContext context) {
        ConductorEntity conductor;
        Player player = context.player();
        Level level = player.level();
        UUID conductorUUID = payload.conductorUUID();
        if (level != null && (conductor = (ConductorEntity)((ServerLevel)level).getEntity(conductorUUID)) != null && !conductor.isOrchestraEmpty()) {
            conductor.setCurrentVolume(payload.volume());
            List<UUID> orchestra = conductor.getOrchestra().stream().map(Entity::getUUID).toList();
            int tickOffset = conductor.getTicksPlaying();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RestartOrchestraMusicS2CPayload(conductorUUID, orchestra, tickOffset, payload.volume(), conductor.getSheetMusic().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handleSyncTipCaseOnNetwork(SyncTipCaseOwnerPayloadC2S payload, IPayloadContext context) {
        UUID uuid = payload.owner();
        BlockPos blockPos = new BlockPos(payload.x(), payload.y(), payload.z());
        ServerLevel level = (ServerLevel)context.player().level();
        BlockState state = level.getBlockState(blockPos);
        Entity entity = level.getEntity(uuid);
        if (state.getBlock() == ModBlocks.TIP_CASE.get() && entity != null) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            ((TipCaseBlockEntity)blockEntity).setOwner(uuid);
        }
    }
}

