/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.particles.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class SleepParticle
extends TextureSheetParticle {
    public static final float SIZE = 0.25f;
    private final SpriteSet spriteSet;

    protected SleepParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.quadSize = 0.1f;
        this.setSize(0.25f, 0.25f);
        this.lifetime = 100;
        this.gravity = 0.0f;
        this.alpha = 0.0f;
        this.yd = Math.abs(ySpeed);
        this.xd = 0.0;
        this.zd = 0.0;
        this.age = 0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        this.y += this.yd;
        this.yd *= 0.98;
        if (this.quadSize < 0.25f) {
            this.quadSize += 0.01f;
            if (this.quadSize > 0.25f) {
                this.quadSize = 0.25f;
            }
        }
        if (this.age < this.lifetime && this.alpha >= 0.0f) {
            if (this.age < 35 && this.alpha < 1.0f) {
                this.alpha += 0.05f;
            } else if (this.age >= 75 && this.alpha > 0.0f) {
                this.alpha -= 0.05f;
            } else if (this.age > 75) {
                this.remove();
            }
        } else {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SleepParticle particle = new SleepParticle(level, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

