/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.screen.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.entity.custom.AnyaGhost;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import oshi.util.tuples.Pair;

public class AnyaScreen {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/gui/entity/dialogue.png");
    public static final int DEFAULT_OFFSET = 80;
    public static final int DEFAULT_BACKGROUND_Y = 160;
    public static final int DEFAULT_BACKGROUND_X = 100;
    public static final int DEFAULT_TEXT_Y = 172;
    public static final int TRANSITION_DURATION = 40;
    public static final int DEFAULT_TEXT_WIDTH = 200;
    public static final double M = 0.5660377358490566;
    public static final double N = -241.69811320754718;
    public static final double My = 0.9760956175298805;
    public static final double Ny = -234.26294820717132;
    public static final LayeredDraw.Layer OVERLAY = AnyaScreen::renderOverlay;
    public static final int POP_UP_TIME = 160;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        if (level != null && player != null) {
            AnyaGhost anya;
            List candidates = level.getEntitiesOfClass(AnyaGhost.class, player.getBoundingBox().inflate(30.0));
            AnyaGhost anyaGhost = anya = candidates.isEmpty() ? null : (AnyaGhost)((Object)candidates.getFirst());
            if (anya != null && anya.tickCount >= 60) {
                int spawnTime = anya.tickCount - 60;
                int normalizedSpawnTime = spawnTime > 160 ? spawnTime - 160 : spawnTime;
                Pair size = new Pair((Object)49, (Object)60);
                Pair location = new Pair((Object)107, (Object)136);
                String text = spawnTime < 160 ? Component.translatable((String)"dialogue.faunaandorchestra.anya0").getString() : Component.translatable((String)"dialogue.faunaandorchestra.anya1").getString();
                int currIconY = (Integer)location.getB() + 80;
                int currBackY = 240;
                int currTextY = 252;
                int currOffset = 80;
                String currentText = "";
                guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
                if (spawnTime <= 40) {
                    currOffset = (int)Math.round(80.0 * (1.0 - Math.pow(1.0 - (double)(normalizedSpawnTime - 1) / 40.0, 4.0)));
                }
                if (normalizedSpawnTime >= 120 && normalizedSpawnTime <= 160 && spawnTime > 160) {
                    currOffset = (int)Math.round(80.0 * (1.0 - Math.pow((double)(normalizedSpawnTime - 120) / 40.0, 4.0)));
                }
                currentText = AnyaScreen.typewritify(text, normalizedSpawnTime, guiGraphics, currTextY, currOffset);
                guiGraphics.blit(BACKGROUND, 100 + AnyaScreen.xOffset(guiGraphics), currBackY - currOffset + AnyaScreen.yOffset(guiGraphics), 0, 0, 223, 40);
                guiGraphics.drawWordWrap(minecraft.font, FormattedText.of((String)currentText), 108 + AnyaScreen.xOffset(guiGraphics), currTextY - currOffset + AnyaScreen.yOffset(guiGraphics) - 5, 200, 0xFFFFFF);
            }
        }
    }

    private static int xOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.5660377358490566 * (double)guiGraphics.guiWidth() + -241.69811320754718);
    }

    private static int yOffset(GuiGraphics guiGraphics) {
        return (int)Math.round(0.9760956175298805 * (double)guiGraphics.guiHeight() + -234.26294820717132);
    }

    private static String typewritify(String fullText, int dialogueTimer, GuiGraphics guiGraphics, int currentTextY, int currentOffset) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (dialogueTimer <= fullText.length()) {
            player.playSound(ModSounds.DIALOGUE.get(), 0.5f, RandomSource.create().nextFloat());
        }
        return dialogueTimer < fullText.length() ? fullText.substring(0, dialogueTimer) : fullText;
    }
}

