/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.sound.custom;

import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class FrogSongSoundInstance
extends AbstractTickableSoundInstance {
    private final QuirkyFrogEntity quirkyFrog;

    public FrogSongSoundInstance(SoundEvent soundEvent, QuirkyFrogEntity quirkyFrog) {
        super(soundEvent, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.quirkyFrog = quirkyFrog;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.volume = 1.0f;
        this.x = quirkyFrog.getX();
        this.y = quirkyFrog.getY();
        this.z = quirkyFrog.getZ();
    }

    public void tick() {
        if (this.quirkyFrog.isDeadOrDying()) {
            this.stop();
        }
        this.x = this.quirkyFrog.getX();
        this.y = this.quirkyFrog.getY();
        this.z = this.quirkyFrog.getZ();
        this.volume = this.calculateVolume();
    }

    private float calculateVolume() {
        double distance = Minecraft.getInstance().player.distanceTo((Entity)this.quirkyFrog);
        return (float)Math.max(0.0, 1.0 - distance * (double)0.025f);
    }

    public void stopSound() {
        this.stop();
    }

    public UUID getFrogUUID() {
        return this.quirkyFrog.getUUID();
    }
}

