/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.sound.custom;

import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class InstrumentSoundInstance
extends AbstractTickableSoundInstance {
    private MusicalEntity entity;
    private int sourceID;
    private Integer ticksOffset;
    private float oVolume;
    private int stopDelay = 5;

    public InstrumentSoundInstance(MusicalEntity entity, SoundEvent soundEvent, float volume, int ticksOffset) {
        super(soundEvent, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.ticksOffset = ticksOffset;
        this.entity = entity;
        this.looping = true;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.delay = 0;
        this.oVolume = volume;
        this.volume = this.calculateVolume();
        this.x = entity.getX();
        this.y = entity.getY();
        this.z = entity.getZ();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (!this.entity.isPlayingInstrument() || this.entity.isRemoved()) {
            if (this.stopDelay > 0) {
                --this.stopDelay;
            } else {
                this.stopSound();
            }
        } else {
            this.stopDelay = 5;
            this.x = this.entity.getX();
            this.y = this.entity.getY();
            this.z = this.entity.getZ();
            this.volume = this.calculateVolume();
        }
    }

    private float calculateVolume() {
        double distance = Minecraft.getInstance().player.distanceTo((Entity)this.entity);
        return (float)Math.max(0.0, (double)this.oVolume - distance * 0.03125);
    }

    public void stopSound() {
        super.stop();
    }

    public MusicalEntity getEntity() {
        return this.entity;
    }

    public int getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(int sourceID) {
        this.sourceID = sourceID;
    }

    public Integer getTicksOffset() {
        return this.ticksOffset;
    }
}

