/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.item.custom.InstrumentItem;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.ModTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class MusicUtil {
    private static final Map<Item, ResourceLocation> BACH_AIR = Map.of((Item)ModItems.VIOLIN.get(), ModSounds.BACH_AIR_VIOLIN.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.BACH_AIR_FLUTE.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.BACH_AIR_KEYTAR.get().getLocation(), (Item)ModItems.DOUBLE_BASS.get(), ModSounds.BACH_AIR_DOUBLE_BASS.get().getLocation());
    public static final Map<Item, ResourceLocation> GREENSLEEVES = Map.of((Item)ModItems.VIOLIN.get(), ModSounds.GREENSLEEVES_VIOLIN.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.GREENSLEEVES_FLUTE.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.GREENSLEEVES_KEYTAR.get().getLocation());
    public static final Map<Item, ResourceLocation> BLUES_SONG = Map.of((Item)ModItems.SAXOPHONE.get(), ModSounds.BLUES_SAXOPHONE.get().getLocation(), (Item)ModItems.DOUBLE_BASS.get(), ModSounds.BLUES_DOUBLE_BASS.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.BLUES_KEYTAR.get().getLocation());
    public static final Map<Item, ResourceLocation> JAZZY_FUR_ELISE = Map.of((Item)ModItems.SAXOPHONE.get(), ModSounds.FUR_ELISE_SAXOPHONE.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.FUR_ELISE_FLUTE.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.FUR_ELISE_KEYTAR.get().getLocation());
    public static final Map<Item, ResourceLocation> SWANS = Map.of((Item)ModItems.OBOE.get(), ModSounds.SWANS_OBOE.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.SWANS_FLUTE.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.SWANS_KEYTAR.get().getLocation());
    public static final Map<Item, ResourceLocation> RESURRECTION = Map.of((Item)ModItems.OBOE.get(), ModSounds.RESURRECTION_OBOE.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.RESURRECTION_FLUTE.get().getLocation(), (Item)ModItems.CELLO.get(), ModSounds.RESURRECTION_CELLO.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.RESURRECTION_KEYTAR.get().getLocation(), (Item)ModItems.VIOLIN.get(), ModSounds.RESURRECTION_VIOLIN.get().getLocation());
    public static final Map<Item, ResourceLocation> LA_BAMBA = Map.of((Item)ModItems.CELLO.get(), ModSounds.BAMBA_CELLO.get().getLocation(), (Item)ModItems.DOUBLE_BASS.get(), ModSounds.BAMBA_DOUBLE_BASS.get().getLocation(), (Item)ModItems.FLUTE.get(), ModSounds.BAMBA_FLUTE.get().getLocation(), (Item)ModItems.KEYTAR.get(), ModSounds.BAMBA_KEYTAR.get().getLocation(), (Item)ModItems.SAXOPHONE.get(), ModSounds.BAMBA_SAXOPHONE.get().getLocation(), (Item)ModItems.VIOLIN.get(), ModSounds.BAMBA_VIOLIN.get().getLocation());
    private static final Map<Item, Map<Item, ResourceLocation>> SONG = Map.of((Item)ModItems.BACH_AIR_SHEET_MUSIC.get(), BACH_AIR, (Item)ModItems.GREENSLEEVES_SHEET_MUSIC.get(), GREENSLEEVES, (Item)ModItems.BLUES_SHEET_MUSIC.get(), BLUES_SONG, (Item)ModItems.JAZZY_FUR_ELISE_SHEET_MUSIC.get(), JAZZY_FUR_ELISE, (Item)ModItems.DANCE_OF_THE_LITTLE_SWANS.get(), SWANS, (Item)ModItems.LA_BAMBA_SHEET_MUSIC.get(), LA_BAMBA, (Item)ModItems.RESURRECTION_SONG.get(), RESURRECTION);
    private static final Map<String, Item> STRING_TO_SHEET = Map.of("faunaandorchestra:bach_air_sheet_music", (Item)ModItems.BACH_AIR_SHEET_MUSIC.get(), "faunaandorchestra:greensleeves_sheet_music", (Item)ModItems.GREENSLEEVES_SHEET_MUSIC.get(), "faunaandorchestra:blues_sheet_music", (Item)ModItems.BLUES_SHEET_MUSIC.get(), "faunaandorchestra:jazzy_fur_elise_sheet_music", (Item)ModItems.JAZZY_FUR_ELISE_SHEET_MUSIC.get(), "faunaandorchestra:dance_of_the_little_swans_sheet_music", (Item)ModItems.DANCE_OF_THE_LITTLE_SWANS.get(), "faunaandorchestra:la_bamba_sheet_music", (Item)ModItems.LA_BAMBA_SHEET_MUSIC.get(), "faunaandorchestra:resurrection_song", (Item)ModItems.RESURRECTION_SONG.get());
    private static final Map<Item, Integer> DURATION = Map.of((Item)ModItems.BACH_AIR_SHEET_MUSIC.get(), 2550, (Item)ModItems.GREENSLEEVES_SHEET_MUSIC.get(), 1315, (Item)ModItems.BLUES_SHEET_MUSIC.get(), 1750, (Item)ModItems.JAZZY_FUR_ELISE_SHEET_MUSIC.get(), 1775, (Item)ModItems.DANCE_OF_THE_LITTLE_SWANS.get(), 1895, (Item)ModItems.LA_BAMBA_SHEET_MUSIC.get(), 1115, (Item)ModItems.RESURRECTION_SONG.get(), 4990);
    public static final List<Item> INSTRUMENTS = new ArrayList<Item>(List.of((Item)ModItems.FLUTE.get(), (Item)ModItems.OBOE.get(), (Item)ModItems.SAXOPHONE.get(), (Item)ModItems.CELLO.get(), (Item)ModItems.DOUBLE_BASS.get(), (Item)ModItems.VIOLIN.get(), (Item)ModItems.KEYTAR.get()));
    private static Map<UUID, Item> CURRENT_ORCHESTRAS = new HashMap<UUID, Item>();

    public static String getLocation(Item sheet, Item instrument) {
        if (sheet.getDefaultInstance().is(ModTags.Items.SHEET_MUSIC)) {
            if (instrument instanceof InstrumentItem) {
                return SONG.get(sheet).get(instrument).getPath();
            }
            throw new IllegalArgumentException("Tried to get the music sound of a non-instrument item!");
        }
        throw new IllegalArgumentException("Tried to get the music sound of a non-sheet item!");
    }

    public static void addNewOrchestra(UUID conductorUUID, Item sheetMusic) {
        CURRENT_ORCHESTRAS.put(conductorUUID, sheetMusic);
    }

    public static void deleteOrchestra(UUID conductorUUID) {
        CURRENT_ORCHESTRAS.remove(conductorUUID);
    }

    public static boolean updateNewSheet(UUID conductorUUID, Item sheetMusic) {
        Item currentSheet = CURRENT_ORCHESTRAS.get(conductorUUID);
        if (currentSheet == sheetMusic) {
            return false;
        }
        CURRENT_ORCHESTRAS.put(conductorUUID, sheetMusic);
        return true;
    }

    public static String musicalAnimalToString(Entity entity) {
        StringJoiner out = new StringJoiner(";");
        String animal = entity.getClass().getSimpleName();
        out.add(animal);
        if (animal.equals("QuirkyFrogEntity")) {
            out.add(((ConductorEntity)entity).isHoldingBaton() ? "t" : "f");
            out.add(((ConductorEntity)entity).getSheetMusic().toString());
            out.add(((ConductorEntity)entity).isHoldingLegendaryBaton() ? "t" : "f");
        } else {
            out.add(((MusicalEntity)entity).isHoldingInstrument() ? "t" : "f");
            out.add("f");
            out.add("f");
        }
        out.add(entity.getCustomName() != null ? entity.getCustomName().getString() : "f");
        return out.toString();
    }

    public static int getMaxSize(Item sheet) {
        return SONG.getOrDefault(sheet, Map.of()).size();
    }

    public static Set<Item> getInstruments(Item sheet) {
        return SONG.get(sheet).keySet();
    }

    public static int getDuration(Item sheet) {
        return DURATION.getOrDefault(sheet, -2);
    }

    public static Item getSheet(UUID conductorUUID) {
        return CURRENT_ORCHESTRAS.get(conductorUUID);
    }

    public static Item getSheet(String name) {
        return STRING_TO_SHEET.getOrDefault(name, Items.AIR);
    }

    public static Item getRandomInstrument(Level level) {
        return INSTRUMENTS.get(level.random.nextInt(0, INSTRUMENTS.size()));
    }
}

