/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import com.mojang.serialization.MapCodec;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.block.ModBlockEntities;
import net.migueel26.faunaandorchestra.block.entity.MelomancyCauldronBlockEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.RecipesUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MelomancyCauldronBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<MelomancyCauldronBlock> CODEC = MelomancyCauldronBlock.simpleCodec(MelomancyCauldronBlock::new);
    public static final IntegerProperty LIQUID = IntegerProperty.create((String)"liquid", (int)0, (int)3);
    public static final BooleanProperty COOKING = BooleanProperty.create((String)"cooking");
    public VoxelShape FLOOR = Block.box((double)2.5, (double)4.0, (double)2.525, (double)13.5, (double)5.0, (double)13.25);
    public VoxelShape EAST_SIDE = Block.box((double)2.5, (double)4.0, (double)2.525, (double)3.5, (double)11.75, (double)13.25);
    public VoxelShape WEST_SIDE = Block.box((double)12.5, (double)4.0, (double)2.525, (double)13.5, (double)11.75, (double)13.25);
    public VoxelShape NORTH_SIDE = Block.box((double)2.5, (double)4.0, (double)2.525, (double)12.5, (double)11.75, (double)3.525);
    public VoxelShape NORTH_TOP_SIDE = Block.box((double)1.65, (double)11.75, (double)1.65, (double)14.35, (double)14.45, (double)2.55);
    public VoxelShape SOUTH_TOP_SIDE = Block.box((double)1.65, (double)11.75, (double)13.25, (double)14.35, (double)14.45, (double)14.25);
    public VoxelShape EAST_TOP_SIDE = Block.box((double)1.65, (double)11.75, (double)1.65, (double)2.65, (double)14.45, (double)14.25);
    public VoxelShape WEST_TOP_SIDE = Block.box((double)13.35, (double)11.75, (double)1.65, (double)14.35, (double)14.45, (double)14.25);
    public VoxelShape SOUTH_SIDE = Block.box((double)2.5, (double)4.0, (double)12.25, (double)13.5, (double)11.75, (double)13.25);
    public VoxelShape SHAPE = Shapes.or((VoxelShape)this.FLOOR, (VoxelShape[])new VoxelShape[]{this.EAST_SIDE, this.WEST_SIDE, this.NORTH_SIDE, this.SOUTH_SIDE, this.EAST_TOP_SIDE, this.WEST_TOP_SIDE, this.NORTH_TOP_SIDE, this.SOUTH_TOP_SIDE});

    public MelomancyCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIQUID, (Comparable)Integer.valueOf(0))).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int liquid = (Integer)state.getValue((Property)LIQUID);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MelomancyCauldronBlockEntity) {
            MelomancyCauldronBlockEntity melomancyCauldronBE = (MelomancyCauldronBlockEntity)blockEntity;
            if (stack.is(Items.BUCKET) && liquid > 0) {
                melomancyCauldronBE.clearContent();
                level.scheduleTick(pos, (Block)this, 20);
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f - level.random.nextFloat() / 2.0f);
                return ItemInteractionResult.SUCCESS;
            }
            if (melomancyCauldronBE.hasFinishedCooking()) {
                if (RecipesUtil.isCorrectItem(stack, melomancyCauldronBE)) {
                    player.addItem(melomancyCauldronBE.getResult());
                    stack.consume(1, (LivingEntity)player);
                    if (!level.isClientSide()) {
                        ((CustomSimpleTrigger)((Object)ModAdvancements.USE_MELOMANCY_CAULDRON.get())).trigger((ServerPlayer)player);
                    }
                    melomancyCauldronBE.clearContent(false);
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.CAULDRON_ITEM.get(), SoundSource.BLOCKS, 1.0f, 0.75f + level.random.nextFloat() / 2.0f);
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIQUID, (Comparable)Integer.valueOf(0))).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false)), 3);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            if (!((Boolean)state.getValue((Property)COOKING)).booleanValue()) {
                if (stack.is(ModItems.MUSIC_BOTTLE) && liquid < 3) {
                    stack.consume(1, (LivingEntity)player);
                    player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                    level.setBlock(pos, (BlockState)state.setValue((Property)LIQUID, (Comparable)Integer.valueOf(liquid + 1)), 3);
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUCKET_EMPTY, SoundSource.NEUTRAL, 1.0f, 1.0f - level.random.nextFloat() / 2.0f);
                    return ItemInteractionResult.SUCCESS;
                }
                if (liquid == 3) {
                    ItemStack itemstack = player.getItemInHand(hand);
                    if (!level.isClientSide && !stack.is(ModItems.MUSIC_BOTTLE) && !stack.isEmpty() && melomancyCauldronBE.addIngredient(player, itemstack)) {
                        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_POP, SoundSource.NEUTRAL, 1.0f, 1.0f - level.random.nextFloat() / 2.0f);
                        ((ServerLevel)level).sendParticles((ParticleOptions)ModParticleTypes.MAGICAL_NOTE.get(), pos.getCenter().x, (double)((float)pos.getY() + 0.75f), pos.getCenter().z, 5, 0.4, 0.1, 0.4, 0.0);
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (stack.isEmpty() && !melomancyCauldronBE.isCooking() && melomancyCauldronBE.cook()) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)COOKING, (Comparable)Boolean.valueOf(true)), 3);
                        return ItemInteractionResult.SUCCESS;
                    }
                    return ItemInteractionResult.CONSUME;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIQUID, (Comparable)Integer.valueOf(0))).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false)), 3);
        super.tick(state, level, pos, random);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)COOKING)).booleanValue() && random.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, ModSounds.CAULDRON_BUBBLING.get(), SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return MelomancyCauldronBlock.createTickerHelper(blockEntityType, ModBlockEntities.MELOMANCY_CAULDRON_BE.get(), MelomancyCauldronBlockEntity::particleTick);
        }
        return (Boolean)state.getValue((Property)COOKING) != false ? MelomancyCauldronBlock.createTickerHelper(blockEntityType, ModBlockEntities.MELOMANCY_CAULDRON_BE.get(), MelomancyCauldronBlockEntity::cookTick) : null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    @javax.annotation.Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MelomancyCauldronBlockEntity(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIQUID, COOKING});
    }
}

