/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class QuirkyFrogModel
extends GeoModel<QuirkyFrogEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/quirky_frog.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/quirky_frog.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/quirky_frog.geo.json");

    public ResourceLocation getModelResource(QuirkyFrogEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(QuirkyFrogEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(QuirkyFrogEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(QuirkyFrogEntity entity, long instanceId, AnimationState<QuirkyFrogEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("frog_head");
        if (head != null && !entity.isConducting()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            if (entity.isHoldingBaton()) {
                head.setRotX((entityData.headPitch() + 45.0f) * ((float)Math.PI / 180));
                head.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180));
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
        }
        GeoBone baton = this.getAnimationProcessor().getBone("baton");
        GeoBone legendaryBaton = this.getAnimationProcessor().getBone("legendary_baton");
        if (entity.isHoldingBaton()) {
            if (entity.isHoldingLegendaryBaton()) {
                baton.setHidden(true);
                legendaryBaton.setHidden(false);
            } else {
                baton.setHidden(false);
                legendaryBaton.setHidden(true);
            }
        } else {
            baton.setHidden(true);
            legendaryBaton.setHidden(true);
        }
    }
}

