/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.RedPandaEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RedPandaModel
extends GeoModel<RedPandaEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/red_panda.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/red_panda.animation.json");
    private static final ResourceLocation MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/red_panda.geo.json");

    public ResourceLocation getModelResource(RedPandaEntity animatable) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(RedPandaEntity animatable) {
        return TEXTURE;
    }

    public ResourceLocation getAnimationResource(RedPandaEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(RedPandaEntity redPanda, long instanceId, AnimationState<RedPandaEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null && !redPanda.isPlayingInstrument() && !animationState.isMoving() && redPanda.isCurrentlyNotChangingStances()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            if (redPanda.isHoldingInstrument() || redPanda.isStanding()) {
                head.setRotX((entityData.headPitch() - 80.0f) * ((float)Math.PI / 180));
                head.setRotZ(-entityData.netHeadYaw() * ((float)Math.PI / 180));
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            }
        }
        GeoBone keytar = this.getAnimationProcessor().getBone("keytar");
        keytar.setHidden(!redPanda.isHoldingInstrument());
    }
}

