/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.migueel26.faunaandorchestra.entity.custom.AbstractCanonEntity;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import vazkii.patchouli.api.PatchouliAPI;

public class AnyaGhost
extends AbstractCanonEntity
implements GeoEntity {
    protected UUID playerUUID;
    public static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.defineId(AnyaGhost.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private final AnimationController<AnyaGhost> anyaController = new AnimationController((GeoAnimatable)this, "anya_ghost_controller", 5, this::anyaState);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnyaGhost(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.skin = null;
        this.playerUUID = null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER_UUID, Optional.empty());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(PLAYER_UUID)) {
            this.playerUUID = ((Optional)this.entityData.get(PLAYER_UUID)).orElse(null);
        }
        super.onSyncedDataUpdated(key);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putUUID("PlayerUUID", this.playerUUID);
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("PlayerUUID")) {
            this.entityData.set(PLAYER_UUID, Optional.of(compound.getUUID("PlayerUUID")));
        }
        super.readAdditionalSaveData(compound);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    private <E extends GeoAnimatable> PlayState anyaState(AnimationState<E> state) {
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.level().isClientSide()) {
            this.setSkin(((AbstractClientPlayer)player).getSkin());
        }
        return InteractionResult.SUCCESS;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void tick() {
        if (this.level().isClientSide() && this.playerUUID != null && this.level().getPlayerByUUID(this.playerUUID) != null) {
            this.setSkin(((AbstractClientPlayer)Objects.requireNonNull(this.level().getPlayerByUUID(this.playerUUID))).getSkin());
        }
        if (!this.level().isClientSide()) {
            if (this.tickCount == 350) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.position().y + 0.5, this.position().z, 40, 0.2, 0.5, 0.2, 0.3);
                ItemEntity itemEntity = new ItemEntity(this.level(), this.position().x, this.position().y + 0.5, this.position().z, PatchouliAPI.get().getBookStack(ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"symphonia")));
                itemEntity.addDeltaMovement(new Vec3(0.0, 0.3, 0.0));
                this.level().addFreshEntity((Entity)itemEntity);
            } else if (this.tickCount == 356) {
                this.discard();
            }
        }
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.entityData.set(PLAYER_UUID, Optional.of(playerUUID));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.anyaController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

