/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import java.util.ArrayList;
import java.util.List;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.goals.ConductorEntityConductingOrchestraGoal;
import net.migueel26.faunaandorchestra.entity.goals.FaunaRandomLookAroundGoal;
import net.migueel26.faunaandorchestra.entity.goals.QuirkyFrogConductingChoirGoal;
import net.migueel26.faunaandorchestra.entity.goals.QuirkyFrogSingGoal;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class QuirkyFrogEntity
extends ConductorEntity
implements GeoEntity {
    protected static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation CROAC = RawAnimation.begin().thenPlay("croac");
    protected static final RawAnimation CONDUCTING = RawAnimation.begin().thenPlay("conducting");
    protected static final RawAnimation HOLDING_BATON = RawAnimation.begin().thenPlay("holding_baton");
    public static final int ANIM_DELAY_TICKS = 10;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private List<QuirkyFrogEntity> frogChoir = new ArrayList<QuirkyFrogEntity>();
    private boolean isSinging;
    private QuirkyFrogEntity frogConductor;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    private int animDelayTicks;
    private final AnimationController<QuirkyFrogEntity> quirkyFrogController = new AnimationController((GeoAnimatable)this, "quirky_frog_controller", 5, this::quirkyFrogState).triggerableAnim("jump", WALK);
    private final AnimationController<QuirkyFrogEntity> quirkyFrogCroacController = new AnimationController((GeoAnimatable)this, "quirky_frog_croac_controller", 3, this::quirkyFrogCroacState).triggerableAnim("croac", CROAC);

    public QuirkyFrogEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.jumpControl = new QuirkyFrogJumpControl(this);
        this.moveControl = new QuirkyFrogMoveControl(this);
        this.isSinging = false;
        this.frogConductor = null;
        this.addOverridenGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 2.0));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ConductorEntityConductingOrchestraGoal(this));
        this.goalSelector.addGoal(1, (Goal)new QuirkyFrogSingGoal(this));
        this.goalSelector.addGoal(1, (Goal)new QuirkyFrogConductingChoirGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new FaunaRandomLookAroundGoal((Mob)this));
    }

    private void addOverridenGoals() {
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 6.0f){
            private int lookTime;

            public boolean canUse() {
                return super.canUse() && !((ConductorEntity)this.mob).isConducting() && !((QuirkyFrogEntity)this.mob).isSinging();
            }

            public boolean canContinueToUse() {
                if (!this.lookAt.isAlive() || ((ConductorEntity)this.mob).isConducting()) {
                    return false;
                }
                return this.mob.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance) ? false : this.lookTime > 0;
            }

            public void start() {
                this.lookTime = this.adjustedTickDelay(40 + this.mob.getRandom().nextInt(40));
            }

            public void tick() {
                if (this.lookAt.isAlive()) {
                    double eyeOffset = ((ConductorEntity)this.mob).isHoldingBaton() ? 1.0 : 2.0;
                    double d0 = this.lookAt.getEyeY() - eyeOffset;
                    this.mob.getLookControl().setLookAt(this.lookAt.getX(), d0, this.lookAt.getZ());
                    --this.lookTime;
                }
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal(this, (PathfinderMob)this, 1.0){
            private int countdown;

            public boolean canUse() {
                return super.canUse() && !((QuirkyFrogEntity)this.mob).isReady() && !((QuirkyFrogEntity)this.mob).isConducting() && ((QuirkyFrogEntity)this.mob).getFrogConductor() == null;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !((QuirkyFrogEntity)this.mob).isSinging() && !((QuirkyFrogEntity)this.mob).isConducting();
            }

            public void start() {
                this.countdown = 0;
                super.start();
            }

            public void tick() {
                ++this.countdown;
                if (this.countdown == 140) {
                    Vec3 pos = this.mob.position();
                    double xdif = pos.x - (double)this.mob.getBlockX();
                    double zdif = pos.z - (double)this.mob.getBlockZ();
                    if (Math.abs(xdif) > Math.abs(zdif)) {
                        this.mob.moveTo(this.mob.getX() + xdif, this.mob.getY() + 1.0, this.mob.getZ());
                    } else {
                        this.mob.moveTo(this.mob.getX(), this.mob.getY() + 1.0, this.mob.getZ() + zdif);
                    }
                    this.countdown = 0;
                }
            }
        });
    }

    protected <E extends GeoAnimatable> PlayState quirkyFrogCroacState(AnimationState<E> state) {
        return PlayState.STOP;
    }

    protected <E extends GeoAnimatable> PlayState quirkyFrogState(AnimationState<E> state) {
        if (this.isConducting()) {
            state.getController().setAnimation(CONDUCTING);
        } else if (this.isHoldingBaton()) {
            state.getController().setAnimation(HOLDING_BATON);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    protected float getJumpPower() {
        Path path;
        float f = 0.3f;
        if (this.horizontalCollision || this.moveControl.hasWanted() && this.moveControl.getWantedY() > this.getY() + 0.5) {
            f = 0.5f;
        }
        if ((path = this.navigation.getPath()) != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
        }
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            f = 0.2f;
        }
        return super.getJumpPower(f / 0.42f);
    }

    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.moveControl.getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float partialTick) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTick) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double speedModifier) {
        this.getNavigation().setSpeedModifier(speedModifier);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), speedModifier);
    }

    public void setJumping(boolean jumping) {
        super.setJumping(jumping);
        if (jumping) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 15;
        this.jumpTicks = 0;
        this.animDelayTicks = 10;
    }

    public void customServerAiStep() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.onGround()) {
            QuirkyFrogJumpControl quirkyfrog$quirkyfrogjumpcontrol;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (!(quirkyfrog$quirkyfrogjumpcontrol = (QuirkyFrogJumpControl)this.jumpControl).wantJump()) {
                if (this.moveControl.hasWanted() && this.jumpDelayTicks == 0) {
                    if (this.animDelayTicks == 10) {
                        this.triggerAnim("quirky_frog_controller", "jump");
                    }
                    if (this.animDelayTicks > 0) {
                        --this.animDelayTicks;
                    }
                    if (this.animDelayTicks == 0) {
                        Path path = this.navigation.getPath();
                        Vec3 vec3 = new Vec3(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                        if (path != null && !path.isDone()) {
                            vec3 = path.getNextEntityPos((Entity)this);
                        }
                        this.facePoint(vec3.x, vec3.z);
                        this.startJumping();
                    }
                }
            } else if (!quirkyfrog$quirkyfrogjumpcontrol.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround();
    }

    private void facePoint(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 180.0 / 3.1415927410125732) - 90.0f);
    }

    private void enableJumpControl() {
        ((QuirkyFrogJumpControl)this.jumpControl).setCanJump(true);
    }

    private void disableJumpControl() {
        ((QuirkyFrogJumpControl)this.jumpControl).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.moveControl.getSpeedModifier() < 2.2 ? 5 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isConducting() ? null : SoundEvents.FROG_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.FROG_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.FROG_DEATH;
    }

    @Nullable
    protected SoundEvent getJumpSound() {
        return SoundEvents.FROG_LONG_JUMP;
    }

    public static boolean checkFrogSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.FROGS_SPAWNABLE_ON) && QuirkyFrogEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isMusical() && player.getMainHandItem().is(ModTags.Items.IS_BATON) && !this.isTame()) {
            if (!this.level().isClientSide()) {
                ((CustomSimpleTrigger)((Object)ModAdvancements.TAME_FROG.get())).trigger((ServerPlayer)player);
            }
            this.tame(player);
            this.playSound(ModSounds.SUCCESSFUL_TAME.get());
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        }
        return super.mobInteract(player, hand);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public List<QuirkyFrogEntity> getFrogChoir() {
        return this.frogChoir;
    }

    public void setFrogChoir(List<QuirkyFrogEntity> frogChoir) {
        this.frogChoir = frogChoir;
        this.setReady(true);
    }

    public boolean isFrogChoirEmpty() {
        return this.frogChoir.isEmpty();
    }

    public boolean isAptForChoir() {
        return !this.isTame() && this.isFrogChoirEmpty() && !this.isSinging();
    }

    public boolean isSinging() {
        return this.isSinging;
    }

    public void setSinging(boolean singing) {
        this.isSinging = singing;
    }

    public QuirkyFrogEntity getFrogConductor() {
        return this.frogConductor;
    }

    public void setFrogConductor(QuirkyFrogEntity frogConductor) {
        this.frogConductor = frogConductor;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.quirkyFrogController);
        controllers.add(this.quirkyFrogCroacController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static class QuirkyFrogJumpControl
    extends JumpControl {
        private final QuirkyFrogEntity quirkyFrog;
        private boolean canJump;

        public QuirkyFrogJumpControl(QuirkyFrogEntity quirkyFrog) {
            super((Mob)quirkyFrog);
            this.quirkyFrog = quirkyFrog;
        }

        public boolean wantJump() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void tick() {
            if (this.jump) {
                this.quirkyFrog.startJumping();
                this.jump = false;
            }
        }
    }

    static class QuirkyFrogMoveControl
    extends MoveControl {
        private final QuirkyFrogEntity quirkyFrog;
        private double nextJumpSpeed;

        public QuirkyFrogMoveControl(QuirkyFrogEntity quirkyFrog) {
            super((Mob)quirkyFrog);
            this.quirkyFrog = quirkyFrog;
        }

        public void tick() {
            if (this.quirkyFrog.onGround() && !this.quirkyFrog.jumping && !((QuirkyFrogJumpControl)this.quirkyFrog.jumpControl).wantJump()) {
                this.quirkyFrog.setSpeedModifier(0.0);
            } else if (this.hasWanted()) {
                this.quirkyFrog.setSpeedModifier(this.nextJumpSpeed);
            }
            super.tick();
        }

        public void setWantedPosition(double x, double y, double z, double speed) {
            if (this.quirkyFrog.isInWater()) {
                speed = 1.5;
            }
            super.setWantedPosition(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }
}

