/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.goals.MusicalEntityPlayingInstrumentGoal;
import net.migueel26.faunaandorchestra.entity.goals.RedPandaRandomChangeStanceGoal;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RedPandaEntity
extends MusicalEntity
implements GeoEntity {
    protected static final RawAnimation WALK = RawAnimation.begin().thenPlay("walking");
    protected static final RawAnimation WALK_STANDING = RawAnimation.begin().thenPlay("walking_standing");
    protected static final RawAnimation WALK_KEYTAR = RawAnimation.begin().thenPlay("walking_keytar");
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_STANDING = RawAnimation.begin().thenPlay("idle_standing");
    protected static final RawAnimation STAND_UP = RawAnimation.begin().thenPlay("stand_up");
    protected static final RawAnimation SIT_DOWN = RawAnimation.begin().thenPlay("sit_down");
    protected static final RawAnimation PLAYING = RawAnimation.begin().thenPlay("playing");
    protected static final RawAnimation IDLE_KEYTAR = RawAnimation.begin().thenPlay("holding_keytar");
    private static final EntityDataAccessor<Boolean> IS_STANDING = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationController<RedPandaEntity> redPandaController = new AnimationController((GeoAnimatable)this, "red_panda_controller", 5, this::redPandaState).triggerableAnim("stand_up_animation", STAND_UP).triggerableAnim("sit_down_animation", SIT_DOWN);

    public RedPandaEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.addOverriddenGoals();
    }

    @Override
    public DeferredItem<Item> getInstrument() {
        return ModItems.KEYTAR;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MusicalEntityPlayingInstrumentGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new RedPandaLookAtPlayerGoal(this, (Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RedPandaRandomChangeStanceGoal(this, 0.05f));
    }

    private <E extends GeoAnimatable> PlayState redPandaState(AnimationState<E> state) {
        if (state.isMoving()) {
            if (this.isHoldingInstrument()) {
                state.getController().setAnimation(WALK_KEYTAR);
            } else {
                state.getController().setAnimation(this.isStanding() ? WALK_STANDING : WALK);
            }
        } else if (this.isPlayingInstrument()) {
            state.getController().setAnimation(PLAYING);
        } else if (this.isHoldingInstrument()) {
            state.getController().setAnimation(IDLE_KEYTAR);
        } else {
            state.getController().setAnimation(this.isStanding() ? IDLE_STANDING : IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void addOverriddenGoals() {
        this.goalSelector.addGoal(0, (Goal)new TamableAnimal.TamableAnimalPanicGoal(this, 2.0, DamageTypeTags.PANIC_CAUSES){
            final RedPandaEntity redPanda;
            {
                this.redPanda = (RedPandaEntity)this.mob;
            }

            public void start() {
                this.redPanda.standUp(false);
                super.start();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal(this, (PathfinderMob)this, 1.0){
            final RedPandaEntity redPanda;
            {
                this.redPanda = (RedPandaEntity)this.mob;
            }

            public boolean canUse() {
                return super.canUse() && this.redPanda.isCurrentlyNotChangingStances();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && this.redPanda.isCurrentlyNotChangingStances();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && RedPandaEntity.this.isCurrentlyNotChangingStances();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && RedPandaEntity.this.isCurrentlyNotChangingStances();
            }
        });
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_STANDING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.standUp(this.isHoldingInstrument());
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BAMBOO);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void standUp(boolean flag) {
        if (!this.isStanding() && flag) {
            this.triggerAnim("red_panda_controller", "stand_up_animation");
        }
        this.entityData.set(IS_STANDING, (Object)flag);
    }

    public void sitDownAnimated() {
        if (this.isStanding()) {
            this.triggerAnim("red_panda_controller", "sit_down_animation");
        }
        this.entityData.set(IS_STANDING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(IS_STANDING);
    }

    public boolean isCurrentlyNotChangingStances() {
        return !this.redPandaController.isPlayingTriggeredAnimation();
    }

    @Override
    public void setHoldingInstrument(boolean holdingInstrument) {
        this.standUp(true);
        super.setHoldingInstrument(holdingInstrument);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.PANDA_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.PANDA_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.PANDA_STEP, 0.15f, 1.25f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isPlayingInstrument() ? null : SoundEvents.PANDA_AMBIENT;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.redPandaController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private class RedPandaLookAtPlayerGoal
    extends LookAtPlayerGoal {
        final RedPandaEntity redPanda;
        private int lookTime;

        public RedPandaLookAtPlayerGoal(RedPandaEntity redPandaEntity, Mob mob, Class<? extends LivingEntity> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
            this.redPanda = (RedPandaEntity)this.mob;
        }

        public boolean canUse() {
            return super.canUse() && this.redPanda.isCurrentlyNotChangingStances();
        }

        public boolean canContinueToUse() {
            if (!this.lookAt.isAlive()) {
                return false;
            }
            return this.redPanda.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance) ? false : this.lookTime > 0 && this.redPanda.isCurrentlyNotChangingStances();
        }

        public void start() {
            this.lookTime = this.adjustedTickDelay(40 + this.mob.getRandom().nextInt(40));
        }

        public void tick() {
            if (this.lookAt.isAlive()) {
                double d0 = this.redPanda.isStanding() ? this.lookAt.getEyeY() - 0.425 : this.lookAt.getEyeY();
                this.redPanda.getLookControl().setLookAt(this.lookAt.getX(), d0, this.lookAt.getZ());
                --this.lookTime;
            }
        }
    }
}

