/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.projectile;

import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PhantomNoteProjectileEntity
extends AbstractHurtingProjectile {
    public static final int MAX_LIFE = 70;
    protected int lifetime = 0;
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.defineId(PhantomNoteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> GOOD = SynchedEntityData.defineId(PhantomNoteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public PhantomNoteProjectileEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public PhantomNoteProjectileEntity(LivingEntity owner, Vec3 movement, Level level) {
        super(ModEntities.PHANTOM_NOTE_PROJECTILE.get(), owner, movement, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEXTURE_INDEX, (Object)this.random.nextInt(8));
        builder.define(GOOD, (Object)false);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void tick() {
        if (this.lifetime >= 70) {
            this.discard();
        } else {
            ++this.lifetime;
        }
        super.tick();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity entity1 = result.getEntity();
            Entity owner = this.getOwner();
            DamageSource source = this.damageSources().magic();
            entity1.hurt(source, 6.0f);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity1, (DamageSource)source);
        }
    }

    protected ParticleOptions getTrailParticle() {
        return this.isBad() ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public boolean isBad() {
        return (Boolean)this.entityData.get(GOOD) == false;
    }

    public int getTextureIndex() {
        return (Integer)this.entityData.get(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.entityData.set(TEXTURE_INDEX, (Object)index);
    }

    public void setGood(boolean good) {
        this.entityData.set(GOOD, (Object)good);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("TextureIndex")) {
            this.setTextureIndex(tag.getInt("TextureIndex"));
        }
        if (tag.contains("Good")) {
            this.entityData.set(GOOD, (Object)tag.getBoolean("Good"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("TextureIndex", this.getTextureIndex());
        tag.putBoolean("Good", ((Boolean)this.entityData.get(GOOD)).booleanValue());
    }
}

