/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.event;

import java.util.List;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.TipCaseBlock;
import net.migueel26.faunaandorchestra.block.entity.TipCaseBlockEntity;
import net.migueel26.faunaandorchestra.effect.ModEffects;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.AnyaGhost;
import net.migueel26.faunaandorchestra.entity.custom.Faust;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="faunaandorchestra", bus=EventBusSubscriber.Bus.GAME)
public class ModGameEvents {
    private static int musicalityIndex;

    @SubscribeEvent
    public static void quirkyFrogChoir(EntityTickEvent.Post event) {
        List<QuirkyFrogEntity> nearbyFrogs;
        QuirkyFrogEntity quirkyFrog;
        Entity entity;
        if (!event.getEntity().level().isClientSide() && event.getEntity().tickCount % 80 == 0 && event.getEntity().level().getRandom().nextFloat() <= 0.01f && (entity = event.getEntity()) instanceof QuirkyFrogEntity && (quirkyFrog = (QuirkyFrogEntity)entity).isAptForChoir() && (nearbyFrogs = quirkyFrog.level().getEntitiesOfClass(QuirkyFrogEntity.class, quirkyFrog.getBoundingBox().inflate(30.0)).stream().filter(QuirkyFrogEntity::isAptForChoir).toList()).size() >= 5) {
            List frogChoir = nearbyFrogs.stream().limit(5L).toList();
            QuirkyFrogEntity choirConductor = (QuirkyFrogEntity)((Object)frogChoir.getFirst());
            choirConductor.setFrogChoir(frogChoir.subList(1, frogChoir.size()));
            for (QuirkyFrogEntity chorister : choirConductor.getFrogChoir()) {
                chorister.setSinging(true);
                chorister.setReady(false);
            }
        }
    }

    @SubscribeEvent
    public static void whistleClickOnEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity;
        ItemStack stack = event.getItemStack();
        if (stack.is(ModItems.WHISTLE) && (entity = event.getTarget()) instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)entity;
            stack.use(event.getLevel(), event.getEntity(), event.getHand());
        }
    }

    @SubscribeEvent
    public static void assignMusicality(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob instanceof MusicalEntity) {
            MusicalEntity musicalEntity = (MusicalEntity)mob;
            if (++musicalityIndex == 3) {
                musicalityIndex = 0;
                musicalEntity.setMusical();
            }
        }
    }

    @SubscribeEvent
    public static void placeTipCase(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity entity = event.getEntity();
        BlockState block = event.getPlacedBlock();
        if (block.getBlock() == ModBlocks.TIP_CASE.get() && entity instanceof Player && !(player = (Player)entity).getMainHandItem().is((Item)ModItems.ICON.get()) && !player.getOffhandItem().is((Item)ModItems.ICON.get())) {
            ((TipCaseBlockEntity)event.getLevel().getBlockEntity(event.getPos())).setOwner(player.getUUID());
        }
    }

    @SubscribeEvent
    public static void onBoogieEnd(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance().is(ModEffects.BOOGIE) && (livingEntity = event.getEntity()) instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)livingEntity;
            mob.setNoAi(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompoundTag persistentData = player2.getPersistentData();
        CompoundTag data = persistentData.getCompound("PlayerPersisted");
        if (!data.getBoolean("hasJoinedBefore")) {
            data.putBoolean("hasJoinedBefore", true);
            persistentData.put("PlayerPersisted", (Tag)data);
            Vec3 look = player2.getLookAngle();
            double distance = 2.0;
            AnyaGhost anyaGhost = new AnyaGhost(ModEntities.ANYA_GHOST.get(), event.getEntity().level());
            anyaGhost.setPos(player2.position().add(look.x * distance, look.y * distance, look.z * distance));
            anyaGhost.lookAt(EntityAnchorArgument.Anchor.FEET, player2.position().add(0.0, 1.0, 0.0));
            anyaGhost.lookAt(EntityAnchorArgument.Anchor.EYES, player2.position().add(0.0, 1.0, 0.0));
            anyaGhost.setYRot(anyaGhost.getYHeadRot());
            anyaGhost.setYBodyRot(anyaGhost.getYRot());
            anyaGhost.setPlayerUUID(player2.getUUID());
            player2.level().addFreshEntity((Entity)anyaGhost);
        }
    }

    @SubscribeEvent
    public static void onFaustTick(EntityTickEvent.Post event) {
        Faust faust;
        Entity entity = event.getEntity();
        if (entity instanceof Faust && (faust = (Faust)entity).getTipCasePos() == null && faust.getOrion() != null) {
            Vec3 vec = faust.position().subtract(faust.getOrion().position());
            Direction facing = Direction.getNearest((Vec3)vec);
            Direction direction = Direction.getNearest((Vec3)vec.yRot(1.5707964f));
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(faust.getX(), faust.getY(), faust.getZ());
            blockPos = blockPos.move(direction);
            event.getEntity().level().setBlock((BlockPos)blockPos, (BlockState)((Block)ModBlocks.TIP_CASE.get()).defaultBlockState().setValue((Property)TipCaseBlock.FACING, (Comparable)facing), 3);
            ((TipCaseBlockEntity)event.getEntity().level().getBlockEntity((BlockPos)blockPos)).setOwner(faust.getUUID());
            faust.setTipCasePos((BlockPos)blockPos);
            BlockPos.MutableBlockPos headPos = blockPos.move(facing.getOpposite());
            event.getEntity().level().setBlock((BlockPos)headPos, (BlockState)((BlockState)((Block)ModBlocks.TIP_CASE.get()).defaultBlockState().setValue((Property)TipCaseBlock.FACING, (Comparable)facing)).setValue(TipCaseBlock.PART, (Comparable)BedPart.HEAD), 3);
            ((TipCaseBlockEntity)event.getEntity().level().getBlockEntity((BlockPos)headPos)).setOwner(faust.getUUID());
        }
    }
}

