/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.item.custom.ActivatorClefItem;
import net.migueel26.faunaandorchestra.item.custom.BatonItem;
import net.migueel26.faunaandorchestra.item.custom.BoogieBombItem;
import net.migueel26.faunaandorchestra.item.custom.BriefcaseItem;
import net.migueel26.faunaandorchestra.item.custom.CustomSpawnEggItem;
import net.migueel26.faunaandorchestra.item.custom.DiscordBombItem;
import net.migueel26.faunaandorchestra.item.custom.DiscordNucleiItem;
import net.migueel26.faunaandorchestra.item.custom.InstrumentItem;
import net.migueel26.faunaandorchestra.item.custom.MelomancyCauldronItem;
import net.migueel26.faunaandorchestra.item.custom.MusicalInkItem;
import net.migueel26.faunaandorchestra.item.custom.PanFluteItem;
import net.migueel26.faunaandorchestra.item.custom.RingtailsPosterItem;
import net.migueel26.faunaandorchestra.item.custom.TheGreatHeadItem;
import net.migueel26.faunaandorchestra.item.custom.TransmutedVoiceItem;
import net.migueel26.faunaandorchestra.item.custom.VoiceVesselItem;
import net.migueel26.faunaandorchestra.item.custom.WhistleItem;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"faunaandorchestra");
    public static final DeferredItem<Item> VIOLIN = ITEMS.register("violin", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.VIOLIN_USE.get()));
    public static final DeferredItem<Item> FLUTE = ITEMS.register("flute", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.FLUTE_USE.get()));
    public static final DeferredItem<Item> KEYTAR = ITEMS.register("keytar", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.KEYTAR_USE.get()));
    public static final DeferredItem<Item> DOUBLE_BASS = ITEMS.register("double_bass", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.DOUBLE_BASS_USE.get()));
    public static final DeferredItem<Item> SAXOPHONE = ITEMS.register("saxophone", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.SAXOPHONE_USE.get()));
    public static final DeferredItem<Item> OBOE = ITEMS.register("oboe", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.OBOE_USE.get()));
    public static final DeferredItem<Item> CELLO = ITEMS.register("cello", () -> new InstrumentItem(new Item.Properties().stacksTo(1), ModSounds.CELLO_USE.get()));
    public static final DeferredItem<Item> PAN_FLUTE = ITEMS.register("pan_flute", () -> new PanFluteItem(new Item.Properties().stacksTo(1).durability(120).component(ModDataComponents.PAN_FLUTE_SOUND, (Object)0).component(ModDataComponents.PAN_FLUTE_LIST, List.of())));
    public static final DeferredItem<Item> PAN_FLUTE_CREATIVE = ITEMS.register("pan_flute_creative", () -> new PanFluteItem(new Item.Properties().stacksTo(1).component(ModDataComponents.PAN_FLUTE_SOUND, (Object)0).component(ModDataComponents.PAN_FLUTE_LIST, new ArrayList<Integer>(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))).rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> BATON = ITEMS.register("baton", () -> new BatonItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> LEGENDARY_BATON = ITEMS.register("legendary_baton", () -> new BatonItem(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> BRIEFCASE = ITEMS.register("briefcase", () -> new BriefcaseItem(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> SINGING_SEED = ITEMS.register("singing_seed", () -> new ItemNameBlockItem((Block)ModBlocks.SINGING_CROP.get(), new Item.Properties()));
    public static final DeferredItem<Item> BOOGIE_FRUIT = ModItems.createRegularDescriptionItem("boogie_fruit");
    public static final DeferredItem<Item> OFFERING = ModItems.createRegularDescriptionItem("offering");
    public static final DeferredItem<Item> WANDERING_NOTE = ITEMS.register("wandering_note", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> AMPLIFIER_CRYSTAL = ITEMS.register("amplifier_crystal", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STEELSONIC_INGOT = ModItems.createRegularDescriptionItem("steelsonic_ingot");
    public static final DeferredItem<Item> GINKGO_BILOBA = ModItems.createRegularDescriptionItem("gingko_biloba");
    public static final DeferredItem<Item> BUTTERFLY_NET = ITEMS.register("butterfly_net", () -> new Item(new Item.Properties().stacksTo(1).durability(32)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.butterfly_net.desc").withStyle(ChatFormatting.GRAY));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> WHISTLE = ITEMS.register("whistle", () -> new WhistleItem(new Item.Properties().stacksTo(1).durability(20)));
    public static final DeferredItem<Item> BOOGIE_BOMB = ITEMS.register("boogie_bomb", () -> new BoogieBombItem(new Item.Properties()));
    public static final DeferredItem<Item> VOICE_VESSEL = ITEMS.register("voice_vessel", () -> new VoiceVesselItem(new Item.Properties().stacksTo(1).component(ModDataComponents.OPENED, (Object)false)));
    public static final DeferredItem<Item> DISCORD_ESSENCE = ModItems.createRegularDescriptionItem("discord_essence");
    public static final DeferredItem<Item> ACTIVATOR_CLEF = ITEMS.register("activator_clef", () -> new ActivatorClefItem(new Item.Properties()));
    public static final DeferredItem<Item> DISCORD_BOMB = ITEMS.register("discord_bomb", () -> new DiscordBombItem(new Item.Properties()));
    public static final DeferredItem<Item> TRANSMUTED_VOICE = ITEMS.register("transmuted_voice", () -> new TransmutedVoiceItem(new Item.Properties()));
    public static final DeferredItem<Item> MUSIC_BOTTLE = ModItems.createRegularDescriptionItem("music_bottle");
    public static final DeferredItem<Item> FRUIT_OF_LIFE = ITEMS.register("fruit_of_life", () -> new Item(new Item.Properties().rarity(Rarity.UNCOMMON)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.fruit_of_life.desc").withStyle(ChatFormatting.GRAY));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> PETALS_OF_DEATH = ITEMS.register("petals_of_death", () -> new Item(new Item.Properties().rarity(Rarity.UNCOMMON)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.petals_of_death.desc").withStyle(ChatFormatting.GRAY));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> SHEET_FRAGMENTS = ITEMS.register("sheet_fragments", () -> new Item(new Item.Properties().rarity(Rarity.UNCOMMON)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.sheet_fragments.desc").withStyle(ChatFormatting.GRAY));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> RINGTAILS_POSTER = ITEMS.register("ringtails_poster", () -> new RingtailsPosterItem(new Item.Properties().rarity(Rarity.RARE)));
    public static final DeferredItem<Item> MUSICAL_INK = ITEMS.register("musical_ink", () -> new MusicalInkItem(new Item.Properties()));
    public static final DeferredItem<Item> GLOVE = ITEMS.register("glove", () -> new Item(new Item.Properties().durability(3)));
    public static final DeferredItem<Item> MANTIS_SPAWN_EGG = ITEMS.register("mantis_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MANTIS, 4647756, 2336296, new Item.Properties()));
    public static final DeferredItem<Item> PENGUIN_SPAWN_EGG = ITEMS.register("penguin_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.PENGUIN, 0xD7D7D9, 921114, new Item.Properties()));
    public static final DeferredItem<Item> RED_PANDA_SPAWN_EGG = ITEMS.register("red_panda_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.RED_PANDA, 14037504, 13750479, new Item.Properties()));
    public static final DeferredItem<Item> MACAW_SPAWN_EGG = ITEMS.register("macaw_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MACAW, 8598, 16771584, new Item.Properties()));
    public static final DeferredItem<Item> BEAVER_SPAWN_EGG = ITEMS.register("beaver_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BEAVER, 1509888, 4201987, new Item.Properties()));
    public static final DeferredItem<Item> LEMUR_SPAWN_EGG = ITEMS.register("lemur_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.LEMUR, 3287593, 0xC1C1C1, new Item.Properties()));
    public static final DeferredItem<Item> MADAME_BUTTERFLY_SPAWN_EGG = ITEMS.register("madame_butterfly_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MADAME_BUTTERFLY, 2335459, 132365, new Item.Properties()));
    public static final DeferredItem<Item> QUIRKY_FROG_SPAWN_EGG = ITEMS.register("quirky_frog_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.QUIRKY_FROG, 2381589, 12565890, new Item.Properties()));
    public static final DeferredItem<Item> WANDERING_KOALA_SPAWN_EGG = ITEMS.register("wandering_koala_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.WANDERING_KOALA, 0xB5B5B5, 0x707070, new Item.Properties()));
    public static final DeferredItem<Item> SPROUTLING_SPAWN_EGG = ITEMS.register("sproutling_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.SINGING_SPROUTLING, 13728058, 3383358, new Item.Properties()));
    public static final DeferredItem<Item> BUTTERFLY_SPAWN_EGG = ITEMS.register("butterfly_spawn_egg", () -> new CustomSpawnEggItem(new Item.Properties(), ModEntities.BUTTERFLY.get()));
    public static final DeferredItem<Item> WISE_TREE_SPAWN_EGG = ITEMS.register("wise_tree_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.WISE_TREE, 6244907, 5668386, new Item.Properties()));
    public static final DeferredItem<Item> RINGTAILS_SPAWN_EGG = ITEMS.register("ringtails_spawn_egg", () -> new CustomSpawnEggItem(new Item.Properties(), new EntityType[]{ModEntities.FAUST.get(), ModEntities.ORION.get()}){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"entity.faunaandorchestra.faust").append((Component)Component.literal((String)" & ")).append((Component)Component.translatable((String)"entity.faunaandorchestra.orion")).withStyle(ChatFormatting.GRAY));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> THE_GREAT_COMPOSER_SPAWN_EGG = ITEMS.register("the_great_composer_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.THE_GREAT_COMPOSER, 14866344, 2337619, new Item.Properties()){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.the_great_composer_spawn_egg.desc").withStyle(ChatFormatting.RED));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    });
    public static final DeferredItem<Item> BACH_AIR_SHEET_MUSIC = ModItems.createSheetMusic("bach_air_sheet_music");
    public static final DeferredItem<Item> GREENSLEEVES_SHEET_MUSIC = ModItems.createSheetMusic("greensleeves_sheet_music");
    public static final DeferredItem<Item> BLUES_SHEET_MUSIC = ModItems.createSheetMusic("blues_sheet_music");
    public static final DeferredItem<Item> JAZZY_FUR_ELISE_SHEET_MUSIC = ModItems.createSheetMusic("jazzy_fur_elise_sheet_music");
    public static final DeferredItem<Item> DANCE_OF_THE_LITTLE_SWANS = ModItems.createSheetMusic("dance_of_the_little_swans_sheet_music");
    public static final DeferredItem<Item> LA_BAMBA_SHEET_MUSIC = ModItems.createSheetMusic("la_bamba_sheet_music");
    public static final DeferredItem<Item> RESURRECTION_SONG = ModItems.createLegendarySheetMusic("resurrection_song");
    public static final DeferredItem<Item> THE_GREAT_HEAD_ITEM = ITEMS.register("the_great_head_item", () -> new TheGreatHeadItem((Block)ModBlocks.THE_GREAT_HEAD.get(), new Item.Properties().rarity(Rarity.EPIC)));
    public static final DeferredItem<Item> MELOMANCY_CAULDRON_ITEM = ITEMS.register("melomancy_cauldron_item", () -> new MelomancyCauldronItem((Block)ModBlocks.MELOMANCY_CAULDRON.get(), new Item.Properties()));
    public static final DeferredItem<Item> DISCORD_NUCLEI_ITEM = ITEMS.register("discord_nuclei_item", () -> new DiscordNucleiItem((Block)ModBlocks.DISCORD_NUCLEI.get(), new Item.Properties()));
    public static final DeferredItem<Item> VOICE = ITEMS.register("voice", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> UNLOCKER = ITEMS.register("unlocker", () -> new Item(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.unlocker.desc"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }

        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.addItem(new ItemStack((ItemLike)SHEET_FRAGMENTS.get()));
                player.addItem(new ItemStack((ItemLike)FRUIT_OF_LIFE.get()));
                player.addItem(new ItemStack((ItemLike)PETALS_OF_DEATH.get()));
                player.addItem(new ItemStack((ItemLike)RESURRECTION_SONG.get()));
                player.addItem(new ItemStack((ItemLike)MUSIC_BOTTLE.get()));
                ((CustomSimpleTrigger)((Object)ModAdvancements.KILL_COMPOSER.get())).trigger(serverPlayer);
                ((CustomSimpleTrigger)((Object)ModAdvancements.WISE_TREE.get())).trigger(serverPlayer);
                ((CustomSimpleTrigger)((Object)ModAdvancements.MEET_RINGTAILS.get())).trigger(serverPlayer);
                ((CustomSimpleTrigger)((Object)ModAdvancements.USE_DISCORD_BOMB.get())).trigger(serverPlayer);
            }
            return super.use(level, player, usedHand);
        }
    });
    public static final DeferredItem<Item> ICON = ITEMS.register("icon", () -> new Item(new Item.Properties().stacksTo(1)));

    private static DeferredItem<Item> createSheetMusic(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().rarity(Rarity.RARE)){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
                MutableComponent instruments = Component.empty();
                Iterator<Item> iterator = MusicUtil.getInstruments(this.asItem()).iterator();
                while (iterator.hasNext()) {
                    instruments.append((Component)Component.translatable((String)iterator.next().getDescriptionId()));
                    if (!iterator.hasNext()) continue;
                    instruments.append((Component)Component.literal((String)", "));
                }
                tooltipComponents.add((Component)instruments.withStyle(ChatFormatting.GRAY));
                super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            }
        });
    }

    private static DeferredItem<Item> createLegendarySheetMusic(final String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().rarity(Rarity.EPIC)){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
                tooltipComponents.add((Component)Component.translatable((String)("item.faunaandorchestra." + name + ".desc")));
                MutableComponent instruments = Component.empty();
                Iterator<Item> iterator = MusicUtil.getInstruments(this.asItem()).iterator();
                while (iterator.hasNext()) {
                    instruments.append((Component)Component.translatable((String)iterator.next().getDescriptionId()));
                    if (!iterator.hasNext()) continue;
                    instruments.append((Component)Component.literal((String)", "));
                }
                tooltipComponents.add((Component)instruments.withStyle(ChatFormatting.GRAY));
                super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            }
        });
    }

    private static DeferredItem<Item> createRegularDescriptionItem(final String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
                tooltipComponents.add((Component)Component.translatable((String)("item.faunaandorchestra." + name + ".desc")).withStyle(ChatFormatting.GRAY));
                super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            }
        });
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

