/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import java.util.UUID;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;

public class BatonItem
extends Item {
    public BatonItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        UUID uuid = (UUID)context.getItemInHand().get(ModDataComponents.MUSICIAN_UUID);
        if (!context.getLevel().isClientSide() && uuid != null) {
            ServerLevel level = (ServerLevel)context.getLevel();
            BlockPos block = context.getClickedPos();
            Mob mob = (Mob)level.getEntity(uuid);
            context.getItemInHand().set(ModDataComponents.MUSICIAN_UUID, null);
            if (mob != null && mob.distanceToSqr(block.getCenter()) < 150.0) {
                mob.getNavigation().moveTo((double)block.getX(), (double)block.getY(), (double)block.getZ(), 1.0);
                level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)block.getX(), (double)block.getY() + 2.5, (double)block.getZ(), 0.0, 0.5, 0.0);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            if (stack.is(ModItems.LEGENDARY_BATON)) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra:legendary_baton"));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra:baton"));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

