/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.ConductorEntity;
import net.migueel26.faunaandorchestra.entity.custom.MusicalEntity;
import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.migueel26.faunaandorchestra.util.MusicUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class BriefcaseItem
extends Item {
    public BriefcaseItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack briefcase = player.getItemInHand(usedHand);
        if (this.calculateHitResult(player).getType() != HitResult.Type.ENTITY && (briefcase.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST) == null || ((List)briefcase.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST)).size() < 6)) {
            if (!level.isClientSide()) {
                if (((Boolean)briefcase.getOrDefault(ModDataComponents.OPENED, (Object)false)).booleanValue()) {
                    briefcase.set(ModDataComponents.OPENED, (Object)false);
                } else {
                    briefcase.set(ModDataComponents.OPENED, (Object)true);
                }
            }
            return InteractionResultHolder.pass((Object)briefcase);
        }
        return InteractionResultHolder.fail((Object)briefcase);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack briefcase = context.getItemInHand();
        List animals = (List)briefcase.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST);
        if (animals != null && !animals.isEmpty() && !((Boolean)briefcase.getOrDefault(ModDataComponents.OPENED, (Object)false)).booleanValue()) {
            if (!context.getLevel().isClientSide()) {
                String animalString = (String)animals.getFirst();
                ArrayList newAnimals = new ArrayList(animals);
                newAnimals.removeFirst();
                ServerLevel level = (ServerLevel)context.getLevel();
                BlockPos block = context.getClickedPos().above();
                briefcase.set(ModDataComponents.BRIEFCASE_ANIMAL_LIST, newAnimals);
                if (newAnimals.isEmpty()) {
                    briefcase.set(ModDataComponents.OPENED, (Object)true);
                }
                this.spawnMusicalEntity(animalString, level, block, context.getPlayer());
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)block.getX(), (double)block.getY(), (double)block.getZ(), 40, 0.5, 0.5, 0.5, 0.0);
            } else {
                context.getLevel().playSound(context.getPlayer(), context.getClickedPos(), SoundEvents.PLAYER_TELEPORT, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnMusicalEntity(String animalString, ServerLevel level, BlockPos block, Player player) {
        ConductorEntity conductor;
        String customName;
        String[] elements = animalString.split(";");
        Object musicalEntityType = null;
        EntityType<QuirkyFrogEntity> conductorEntityType = null;
        switch (elements[0]) {
            case "MantisEntity": {
                musicalEntityType = ModEntities.MANTIS.get();
                break;
            }
            case "PenguinEntity": {
                musicalEntityType = ModEntities.PENGUIN.get();
                break;
            }
            case "RedPandaEntity": {
                musicalEntityType = ModEntities.RED_PANDA.get();
                break;
            }
            case "MacawEntity": {
                musicalEntityType = ModEntities.MACAW.get();
                break;
            }
            case "BeaverEntity": {
                musicalEntityType = ModEntities.BEAVER.get();
                break;
            }
            case "LemurEntity": {
                musicalEntityType = ModEntities.LEMUR.get();
                break;
            }
            case "MadameButterflyEntity": {
                musicalEntityType = ModEntities.MADAME_BUTTERFLY.get();
                break;
            }
            case "QuirkyFrogEntity": {
                conductorEntityType = ModEntities.QUIRKY_FROG.get();
            }
        }
        boolean holdingInstrument = elements[1].equals("t");
        Item sheet = MusicUtil.getSheet(elements[2]);
        boolean legendaryBaton = elements[3].equals("t");
        String string = customName = elements[4].equals("f") ? null : elements[3];
        if (musicalEntityType != null) {
            MusicalEntity musicalEntity = (MusicalEntity)musicalEntityType.spawn(level, block, MobSpawnType.MOB_SUMMONED);
            if (musicalEntity != null) {
                musicalEntity.tame(player);
                musicalEntity.setHoldingInstrument(holdingInstrument);
                musicalEntity.setOrderedToSit(true);
                if (customName != null) {
                    musicalEntity.setCustomName((Component)Component.literal((String)customName));
                }
            }
        } else if (conductorEntityType != null && (conductor = (ConductorEntity)conductorEntityType.spawn(level, block, MobSpawnType.MOB_SUMMONED)) != null) {
            conductor.tame(player);
            conductor.setHoldingBaton(holdingInstrument);
            conductor.setLegendaryBaton(legendaryBaton);
            conductor.setOrderedToSit(true);
            if (sheet != Items.AIR) {
                conductor.inventory.setStackInSlot(0, new ItemStack((ItemLike)sheet));
            }
            if (customName != null) {
                conductor.setCustomName((Component)Component.literal((String)customName));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        List animals = (List)stack.get(ModDataComponents.BRIEFCASE_ANIMAL_LIST);
        if (Screen.hasShiftDown()) {
            if (animals == null || animals.size() < 6) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra:briefcase_empty"));
            }
            if (animals != null && !animals.isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra:briefcase_full"));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        if (animals != null) {
            for (String animalString : animals) {
                BriefcaseItem.addStoredAnimal(tooltipComponents, animalString);
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static void addStoredAnimal(List<Component> tooltipComponents, String animalString) {
        if (animalString != null) {
            String[] elements = animalString.split(";");
            MutableComponent typeName = null;
            String name = elements[3].equals("f") ? null : elements[3];
            switch (elements[0]) {
                case "MantisEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.mantis");
                    break;
                }
                case "PenguinEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.penguin");
                    break;
                }
                case "RedPandaEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.red_panda");
                    break;
                }
                case "MacawEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.macaw");
                    break;
                }
                case "QuirkyFrogEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.quirky_frog");
                    break;
                }
                case "BeaverEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.beaver");
                    break;
                }
                case "LemurEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.lemur");
                    break;
                }
                case "MadameButterflyEntity": {
                    typeName = Component.translatable((String)"entity.faunaandorchestra.madame_butterfly");
                }
            }
            if (typeName != null) {
                if (name != null) {
                    tooltipComponents.add((Component)typeName.append((Component)Component.literal((String)(" (" + name + ")"))).withStyle(ChatFormatting.DARK_GRAY));
                } else {
                    tooltipComponents.add((Component)typeName.withStyle(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> !entity.isSpectator() && entity.isPickable(), (double)player.blockInteractionRange());
    }
}

