/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.advancements.CustomSimpleTrigger;
import net.migueel26.faunaandorchestra.advancements.ModAdvancements;
import net.migueel26.faunaandorchestra.entity.custom.projectile.ThrownDiscordBomb;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DiscordBombItem
extends Item
implements ProjectileItem {
    public DiscordBombItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            level.playSound(null, player.blockPosition(), SoundEvents.SPLASH_POTION_THROW, SoundSource.NEUTRAL);
            ThrownDiscordBomb thrownpotion = new ThrownDiscordBomb(level, (LivingEntity)player);
            thrownpotion.setItem(itemstack);
            thrownpotion.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)thrownpotion);
            ((CustomSimpleTrigger)((Object)ModAdvancements.USE_DISCORD_BOMB.get())).trigger((ServerPlayer)player);
        }
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.discord_bomb.desc").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new ThrownDiscordBomb(level, pos.x(), pos.y(), pos.z());
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.25f).build();
    }
}

