/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class TransmutedVoiceItem
extends Item {
    public TransmutedVoiceItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        EntityHitResult entityHitResult;
        HitResult hitResult = this.calculateHitResult(player);
        if (hitResult instanceof EntityHitResult && (entityHitResult = (EntityHitResult)hitResult).getEntity().isSilent()) {
            Entity entity = entityHitResult.getEntity();
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, entity.getX(), entity.getY(), entity.getZ(), 30, 0.25, 0.25, 0.25, 0.15);
            }
            level.playSound(player, entity.blockPosition(), ModSounds.VESSEL_COLLECT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            entity.setSilent(false);
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.transmuted_voice.tooltip"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> !entity.isSpectator() && entity.isPickable(), (double)player.blockInteractionRange());
    }
}

