/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.item.custom;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.migueel26.faunaandorchestra.client.item.VoiceVesselItemRenderer;
import net.migueel26.faunaandorchestra.component.ModDataComponents;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.particles.custom.VoiceParticle;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.migueel26.faunaandorchestra.util.PlayerUtil;
import net.migueel26.faunaandorchestra.util.VesselUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoiceVesselItem
extends Item
implements GeoItem {
    protected static final int ABSORB_TIME = 80;
    protected Mob mob = null;
    protected Vec3 particlePos = null;
    protected int timestamp = -1;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    protected static RawAnimation CLOSE = RawAnimation.begin().thenPlayAndHold("close");
    protected static RawAnimation ABSORB = RawAnimation.begin().thenPlay("absorb");

    public VoiceVesselItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (stack.is((Item)this) && stack.has(ModDataComponents.OPENED)) {
            if (!((Boolean)stack.get(ModDataComponents.OPENED)).booleanValue()) {
                if (!level.isClientSide()) {
                    this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)player.getItemInHand(usedHand), (ServerLevel)((ServerLevel)level)), "vessel_controller", "open");
                }
                level.playSound(player, player.blockPosition(), ModSounds.VESSEL_CLICK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() / 2.0f - 0.25f));
                stack.set(ModDataComponents.OPENED, (Object)true);
                player.startUsingItem(usedHand);
            } else {
                this.releaseUsing(stack, level, (LivingEntity)player, 1);
            }
        }
        return super.use(level, player, usedHand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (this.mob == null) {
            Optional<Mob> pEntity = level.getNearbyEntities(Mob.class, TargetingConditions.DEFAULT, livingEntity, livingEntity.getBoundingBox().inflate(7.0)).stream().filter(VesselUtil::isEntityAptForVessel).filter(mob -> !mob.isSilent()).findFirst();
            if (pEntity.isPresent()) {
                this.mob = pEntity.get();
                this.mob.playAmbientSound();
                this.timestamp = remainingUseDuration;
            }
        } else if (stack.has(ModDataComponents.OPENED) && ((Boolean)stack.get(ModDataComponents.OPENED)).booleanValue()) {
            if (remainingUseDuration % 5 == 0 && level.isClientSide()) {
                level.playSound((Entity)livingEntity, livingEntity.blockPosition(), ModSounds.VESSEL_AIR.get(), SoundSource.PLAYERS, 0.1f, 1.0f + (level.random.nextFloat() - 0.5f));
            }
            if (remainingUseDuration == this.timestamp - 80) {
                this.particlePos = this.mob.position().add(0.0, (double)this.mob.getBbHeight() + 1.5, 0.0);
                level.addParticle((ParticleOptions)ModParticleTypes.VOICE_PARTICLE.get(), this.mob.getX(), this.particlePos.y - 1.5, this.mob.getZ(), 0.0, (double)0.35f, 0.0);
                level.playSound((Entity)livingEntity, livingEntity.blockPosition(), ModSounds.VESSEL_COLLECT.get(), SoundSource.NEUTRAL, 1.0f, 0.5f);
            }
            if (remainingUseDuration == this.timestamp - 80 - 40 || remainingUseDuration == this.timestamp - 80 - VoiceParticle.LIFETIME) {
                if (!level.isClientSide()) {
                    PlayerUtil.spawnParticlesFromTo(ParticleTypes.CLOUD, 1, (ServerLevel)level, this.particlePos, livingEntity.position().add(0.0, 1.0, 0.0));
                }
                level.playSound((Entity)livingEntity, livingEntity.blockPosition(), ModSounds.VESSEL_COLLECT.get(), SoundSource.NEUTRAL, 1.0f, 1.5f);
            }
            if (remainingUseDuration == this.timestamp - 80 - VoiceParticle.LIFETIME - 60) {
                if (!level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.particlePos.x(), this.particlePos.y(), this.particlePos.z(), 40, 0.3, 0.3, 0.3, 0.1);
                    PlayerUtil.spawnParticlesFromTo(ParticleTypes.CLOUD, 3, (ServerLevel)level, this.particlePos, livingEntity.position().add(0.0, 1.0, 0.0));
                }
                ((Player)livingEntity).addItem(VesselUtil.voiceOfEntity((EntityType<? extends Entity>)this.mob.getType()));
                level.playSound((Entity)livingEntity, livingEntity.blockPosition(), ModSounds.VESSEL_COLLECT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (remainingUseDuration == this.timestamp - 80 - VoiceParticle.LIFETIME - 65) {
                livingEntity.releaseUsingItem();
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (!level.isClientSide()) {
            this.triggerAnim((Entity)livingEntity, GeoItem.getOrAssignId((ItemStack)livingEntity.getItemInHand(livingEntity.getUsedItemHand()), (ServerLevel)((ServerLevel)level)), "vessel_controller", "close");
        }
        if (((Boolean)stack.get(ModDataComponents.OPENED)).booleanValue()) {
            level.playSound((Entity)livingEntity, livingEntity.blockPosition(), ModSounds.VESSEL_CLICK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() / 2.0f - 0.25f));
        }
        stack.set(ModDataComponents.OPENED, (Object)false);
        if (this.mob != null) {
            this.mob.setSilent(true);
        }
        this.mob = null;
        this.timestamp = -1;
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "vessel_controller", 1, this::predicate).triggerableAnim("open", OPEN).triggerableAnim("close", CLOSE));
    }

    private <T extends GeoItem> PlayState predicate(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack.has(ModDataComponents.OPENED) && ((Boolean)stack.get(ModDataComponents.OPENED)).booleanValue()) {
            state.getController().setAnimation(ABSORB);
        } else {
            state.getController().stop();
        }
        return PlayState.CONTINUE;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private VoiceVesselItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new VoiceVesselItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.faunaandorchestra.voice_vessel.tooltip"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.faunaandorchestra.shift"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

